/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.util.PathUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootFeatureUsagesCollector
extends ProjectUsagesCollector {
    private static final String[] files = new String[]{"application.properties", "bootstrap.properties", "additional-spring-configuration-metadata.json", "application.yml", "application.yaml", "devtools.properties", "devtools.yml", "devtools.yaml"};
    private static final List<Integer> steps = Arrays.asList(1, 2, 3, 4, 5, 10, 100, 1000);

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            SpringBootFeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                SpringBootFeatureUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        int springBootModulesPerProject = 0;
        LinkedHashSet<MetricEvent> metrics = new LinkedHashSet<MetricEvent>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List configurationPropertiesMethods;
            ProgressManager.checkCanceled();
            if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) continue;
            ++springBootModulesPerProject;
            if (SpringBootLibraryUtil.hasDevtools(module)) {
                metrics.add(MetricEventFactoryKt.newMetric((String)"spring.boot.dev.tools"));
            }
            GlobalSearchScope scope = module.getModuleScope(false);
            for (String file : files) {
                ProgressManager.checkCanceled();
                Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)file, (GlobalSearchScope)scope);
                if (files.isEmpty()) continue;
                metrics.add(MetricEventFactoryKt.newMetric((String)"configuration.file", (FeatureUsageData)new FeatureUsageData().addData("name", FileUtil.getNameWithoutExtension((String)file)).addData("extension", StringUtil.notNullize((String)PathUtil.getFileExtension((String)file), (String)"unknown")).addData("count", files.size()).addData("files", StatisticsUtil.INSTANCE.getCountingStepName(files.size(), steps))));
            }
            List configurationProperties = JamService.getJamService((Project)project).getJamClassElements(ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
            if (!configurationProperties.isEmpty()) {
                metrics.add(MetricEventFactoryKt.newMetric((String)"configuration.properties", (FeatureUsageData)new FeatureUsageData().addData("count", configurationProperties.size()).addData("files", StatisticsUtil.INSTANCE.getCountingStepName(configurationProperties.size(), steps))));
                List nestedConfigurationProperties = JamService.getJamService((Project)project).getJamFieldElements(NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", scope);
                if (!nestedConfigurationProperties.isEmpty()) {
                    metrics.add(MetricEventFactoryKt.newMetric((String)"nested.configuration.properties", (FeatureUsageData)new FeatureUsageData().addData("count", nestedConfigurationProperties.size()).addData("files", StatisticsUtil.INSTANCE.getCountingStepName(nestedConfigurationProperties.size(), steps))));
                }
            }
            if ((configurationPropertiesMethods = JamService.getJamService((Project)project).getJamMethodElements(ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope)).isEmpty()) continue;
            metrics.add(MetricEventFactoryKt.newMetric((String)"configuration.properties.methods", (FeatureUsageData)new FeatureUsageData().addData("count", configurationPropertiesMethods.size()).addData("files", StatisticsUtil.INSTANCE.getCountingStepName(configurationPropertiesMethods.size(), steps))));
        }
        metrics.add(MetricEventFactoryKt.newMetric((String)"spring.boot.modules.per.project", (FeatureUsageData)new FeatureUsageData().addData("count", springBootModulesPerProject).addData("modules", StatisticsUtil.INSTANCE.getCountingStepName(springBootModulesPerProject, steps))));
        LinkedHashSet<MetricEvent> linkedHashSet = metrics;
        if (linkedHashSet == null) {
            SpringBootFeatureUsagesCollector.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @NotNull
    public String getGroupId() {
        return "spring.boot";
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/SpringBootFeatureUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/SpringBootFeatureUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

