/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.JavaFxCSSElementDescriptionProvider;
import org.jetbrains.plugins.javaFX.css.JavaFxCssHelper;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCssIdSelectorReference;

public class JavaFxCSSReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JavaFxCSSReferenceContributor.$$$reportNull$$$0(0);
        }
        XmlAttributeValuePattern attributeValueInFxml = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension("fxml"));
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("styleClass"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxCssReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute().withName("fx:id"))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxIdCssReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withName("fx:value")).withParent((ElementPattern)XmlPatterns.xmlTag().withParent((ElementPattern)XmlPatterns.xmlTag().withName("styleClass"))))).and((ElementPattern)attributeValueInFxml), (PsiReferenceProvider)new JavaFxCssReferenceProvider());
        PatternCondition<PsiElement> javaFxCssPattern = new PatternCondition<PsiElement>("javafx-css"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JavaFxCSSElementDescriptionProvider.isJavaFXCSS(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$1", "accepts"));
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_CLASS))).with((PatternCondition)javaFxCssPattern), (PsiReferenceProvider)new JavaFxDefaultStyleClassReferenceProvider());
    }

    public static Collection<VirtualFile> getMyCss(PsiElement element) {
        Project project = element.getProject();
        PsiManager psiManager = element.getManager();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        return (Collection)manager.getCachedValue((UserDataHolder)project, () -> {
            Collection files = FileTypeIndex.getFiles((FileType)CssFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                VirtualFile file = (VirtualFile)iterator.next();
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile != null && JavaFxCSSElementDescriptionProvider.isJavaFXCSS((PsiElement)psiFile)) continue;
                iterator.remove();
            }
            return new CachedValueProvider.Result((Object)files, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor", "registerReferenceProviders"));
    }

    private static class JavaFxIdCssReferenceProvider
    extends PsiReferenceProvider {
        private JavaFxIdCssReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                JavaFxIdCssReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JavaFxIdCssReferenceProvider.$$$reportNull$$$0(1);
            }
            if (element instanceof XmlAttributeValue) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JavaFxCssIdSelectorReference((XmlAttributeValue)element)};
                if (psiReferenceArray == null) {
                    JavaFxIdCssReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxIdCssReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxIdCssReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxIdCssReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavaFxStyleClassImmediateRef
    extends PsiReferenceBase.Immediate<CssTokenImpl> {
        JavaFxStyleClassImmediateRef(PsiElement element, PsiClass psiClass) {
            super((PsiElement)((CssTokenImpl)element), (PsiElement)psiClass);
        }

        public Object @NotNull [] getVariants() {
            Set<String> styleClasses = JavaFxCssHelper.getDefaultStyleClasses();
            Object[] objectArray = ArrayUtilRt.toStringArray(styleClasses);
            if (objectArray == null) {
                JavaFxStyleClassImmediateRef.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxStyleClassImmediateRef", "getVariants"));
        }
    }

    private static class JavaFxDefaultStyleClassReferenceProvider
    extends PsiReferenceProvider {
        private JavaFxDefaultStyleClassReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                JavaFxDefaultStyleClassReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JavaFxDefaultStyleClassReferenceProvider.$$$reportNull$$$0(1);
            }
            String simpleClassName = element.getText();
            if (JavaFxCssHelper.getDefaultStyleClasses().contains(simpleClassName)) {
                Project project = element.getProject();
                PsiClass[] classesByName = PsiShortNamesCache.getInstance((Project)project).getClassesByName(JavaFxDefaultStyleClassReferenceProvider.getShortClassName(simpleClassName), GlobalSearchScope.allScope((Project)project));
                ArrayList<JavaFxStyleClassImmediateRef> classRefs = new ArrayList<JavaFxStyleClassImmediateRef>();
                for (PsiClass psiClass : classesByName) {
                    String qualifiedName = psiClass.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.startsWith("javafx.")) continue;
                    classRefs.add(new JavaFxStyleClassImmediateRef(element, psiClass));
                }
                if (!classRefs.isEmpty()) {
                    PsiReference[] psiReferenceArray = classRefs.toArray(PsiReference.EMPTY_ARRAY);
                    if (psiReferenceArray == null) {
                        JavaFxDefaultStyleClassReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new JavaFxStyleClassImmediateRef(element, null)};
            if (psiReferenceArray == null) {
                JavaFxDefaultStyleClassReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }

        private static String getShortClassName(String styleClassName) {
            boolean capitalize = true;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < styleClassName.length(); ++i) {
                char ch = styleClassName.charAt(i);
                if (capitalize) {
                    buf.append(Character.toUpperCase(ch));
                    capitalize = false;
                    continue;
                }
                if (ch == '-') {
                    capitalize = true;
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxDefaultStyleClassReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxDefaultStyleClassReferenceProvider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JavaFxCssReference
    extends CssClassOrIdReference {
        private final Collection<VirtualFile> myCssFiles;

        public JavaFxCssReference(PsiElement element, TextRange textRange) {
            super(element, textRange);
            this.myCssFiles = JavaFxCSSReferenceContributor.getMyCss(element);
        }

        protected boolean hasExplicitIdMark() {
            return false;
        }

        protected boolean isId() {
            return false;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                JavaFxCssReference.$$$reportNull$$$0(0);
            }
            if (!this.myCssFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)element.getContainingFile()))) {
                return false;
            }
            String canonicalText = this.getCanonicalText();
            String name = ((PsiNamedElement)element).getName();
            return Comparing.strEqual((String)canonicalText, (String)name);
        }

        protected GlobalSearchScope getSearchScope() {
            return GlobalSearchScope.filesWithLibrariesScope((Project)this.getElement().getProject(), this.myCssFiles);
        }

        public Collection<VirtualFile> getCssFiles() {
            return this.myCssFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxCssReference", "isReferenceTo"));
        }
    }

    private static class JavaFxCssReferenceProvider
    extends PsiReferenceProvider {
        private JavaFxCssReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                JavaFxCssReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JavaFxCssReferenceProvider.$$$reportNull$$$0(1);
            }
            XmlAttributeValue xmlAttValue = (XmlAttributeValue)element;
            String value = xmlAttValue.getValue().trim();
            ArrayList<JavaFxCssReference> refs = new ArrayList<JavaFxCssReference>();
            int start = 0;
            while (start < value.length()) {
                while (Character.isWhitespace(value.charAt(start))) {
                    ++start;
                }
                int end = value.indexOf(",", start);
                if (end < 0) {
                    end = value.length();
                }
                refs.add(new JavaFxCssReference((PsiElement)xmlAttValue, new TextRange(start + 1, end + 1)));
                if (end == value.length()) break;
                start = end + 1;
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                JavaFxCssReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxCssReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxCSSReferenceContributor$JavaFxCssReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

