/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.manipulators;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.hibernate.model.enums.CascadeType;
import com.intellij.hibernate.model.enums.HibernateAttributeType;
import com.intellij.hibernate.model.enums.LazyType;
import com.intellij.hibernate.model.enums.NotFoundType;
import com.intellij.hibernate.model.manipulators.HibernateObjectManipulator;
import com.intellij.hibernate.model.xml.impl.mapping.HbmEmbeddableImpl;
import com.intellij.hibernate.model.xml.mapping.HbmAny;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmComponent;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeElement;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmDynamicComponent;
import com.intellij.hibernate.model.xml.mapping.HbmElement;
import com.intellij.hibernate.model.xml.mapping.HbmEmbeddedAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmIdbag;
import com.intellij.hibernate.model.xml.mapping.HbmManyToOneBase;
import com.intellij.hibernate.model.xml.mapping.HbmNestedCompositeElement;
import com.intellij.hibernate.model.xml.mapping.HbmOneToOne;
import com.intellij.hibernate.model.xml.mapping.HbmPrimitiveArray;
import com.intellij.hibernate.model.xml.mapping.HbmPropertyBase;
import com.intellij.hibernate.model.xml.mapping.HbmRelationAttributeBase;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.manipulators.ObjectManipulatorBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateEmbeddableManipulator
extends ObjectManipulatorBase<HbmEmbeddableImpl> {
    public HibernateEmbeddableManipulator(HbmEmbeddableImpl target) {
        super((PersistentObject)target);
    }

    public List<PersistenceAction> getCreateActions() {
        ArrayList<PersistenceAction> result = new ArrayList<PersistenceAction>();
        for (AttributeType type : PersistenceAttributesProvider.values()) {
            if (!(type instanceof HibernateAttributeType) || !ReflectionUtil.isAssignable(DomElement.class, (Class)type.getAttributeClass()) || type == HibernateAttributeType.ID || type == HibernateAttributeType.TIMESTAMP || type == HibernateAttributeType.VERSION || type == HibernateAttributeType.COMPOSITE_ID || type == HibernateAttributeType.ONE_TO_MANY || type == HibernateAttributeType.MANY_TO_MANY) continue;
            result.add((PersistenceAction)new MyDomAttributeAction(this, (HibernateAttributeType)type));
        }
        return result;
    }

    public void setTable(DasTable tableInfo) throws IncorrectOperationException {
        throw new AssertionError((Object)"operation not supported");
    }

    public PersistentEmbeddedAttribute addEmbeddedAttribute(PersistentEmbeddable embeddable, String attributeName, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass embeddableClass;
        HbmEmbeddableImpl object = (HbmEmbeddableImpl)this.getManipulatorTarget();
        ArrayList<HbmEmbeddedAttributeBase> result = new ArrayList<HbmEmbeddedAttributeBase>();
        for (HbmEmbeddedAttributeBase attribute : object.getDefiningAttributes()) {
            HbmEmbeddedAttributeBase attr = attribute instanceof HbmComponent ? ((HbmComponent)attribute).addComponent() : (attribute instanceof HbmCompositeElement ? ((HbmCompositeElement)attribute).addNestedCompositeElement() : (attribute instanceof HbmNestedCompositeElement ? ((HbmNestedCompositeElement)attribute).addNestedCompositeElement() : (attribute instanceof HbmCompositeId ? null : null)));
            if (attr == null) continue;
            attr.getName().setValue((Object)attributeName);
            attr.getClazz().setValue((Object)((PsiClass)embeddable.getClazz().getValue()));
            result.add(attr);
        }
        if (result.isEmpty()) {
            return null;
        }
        if (this.ensureClassExists() == null) {
            return (PersistentEmbeddedAttribute)result.get(0);
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)embeddable, PersistentObjectManipulator.class);
        if (manipulator == null || (embeddableClass = manipulator.ensureClassExists()) == null) {
            return (PersistentEmbeddedAttribute)result.get(0);
        }
        for (HbmEmbeddedAttributeBase attr : result) {
            attr.getClazz().setValue((Object)((PsiClass)embeddable.getClazz().getValue()));
        }
        this.ensurePropertyExists((PsiClass)((HbmEmbeddableImpl)this.getManipulatorTarget()).getClazz().getValue(), attributeName, (PsiType)JavaPsiFacade.getInstance((Project)embeddableClass.getProject()).getElementFactory().createType(embeddableClass), accessMode, PsiAnnotation.EMPTY_ARRAY);
        return (PersistentEmbeddedAttribute)result.get(0);
    }

    public PersistentRelationshipAttribute addRelationshipAttribute(PersistentEntityBase entity, RelationshipType relationshipType, JavaContainerType containerType, String attributeName, String targetAttributeName, boolean inverse, boolean optional, String fetchType, Collection<String> cascadeVariants, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass entityClass;
        assert (!relationshipType.isMany(false)) : "to-many associations forbidden";
        ArrayList results = new ArrayList();
        this.processDefiningAttributes((PairProcessor<HbmEmbeddedAttributeBase, AttributeManipulator>)((PairProcessor)(hbmEmbeddedAttributeBase, attributeManipulator) -> {
            HbmRelationAttributeBase.AnyToOneBase attrBase;
            switch (relationshipType) {
                case MANY_TO_ONE: {
                    attrBase = attributeManipulator.addManyToOne((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                    break;
                }
                case ONE_TO_ONE: {
                    attrBase = attributeManipulator.addOneToOne((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (attrBase != null) {
                DomElement parent;
                attrBase.getName().setValue((Object)attributeName);
                attrBase.getName().setValue((Object)attributeName);
                ArrayList<CascadeType> cascadeTypesValue = new ArrayList<CascadeType>();
                for (CascadeType cascadeType : CascadeType.values()) {
                    if (!cascadeVariants.contains(cascadeType.getDisplayName())) continue;
                    cascadeTypesValue.add(cascadeType);
                }
                if (!cascadeTypesValue.isEmpty()) {
                    attrBase.getCascade().setValue(cascadeTypesValue);
                }
                if (fetchType != null) {
                    for (Enum enum_ : LazyType.values()) {
                        if (!((LazyType)enum_).getDisplayName().equals(fetchType)) continue;
                        attrBase.getLazy().setValue((Object)enum_);
                        break;
                    }
                }
                if (optional && attrBase instanceof HbmRelationAttributeBase.AnyToManyBase) {
                    ((HbmRelationAttributeBase.AnyToManyBase)((Object)attrBase)).getNotFound().setValue((Object)(optional ? NotFoundType.IGNORE : NotFoundType.EXCEPTION));
                }
                if (inverse && (parent = attrBase.getParent()) instanceof HbmContainer && !(parent instanceof HbmPrimitiveArray) && !(parent instanceof HbmIdbag)) {
                    ((HbmContainer)parent).getInverse().setValue((Object)Boolean.TRUE);
                }
                results.add(attrBase);
            }
            return true;
        }));
        if (results.isEmpty()) {
            return null;
        }
        PsiClass curClass = this.ensureClassExists();
        if (curClass == null) {
            return (PersistentRelationshipAttribute)results.get(0);
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
        if (manipulator == null || (entityClass = manipulator.ensureClassExists()) == null) {
            return (PersistentRelationshipAttribute)results.get(0);
        }
        for (HbmRelationAttributeBase attrBase : results) {
            attrBase.getTargetEntityClass().setValue((Object)entityClass);
        }
        PsiClassType entityClassType = JavaPsiFacade.getInstance((Project)curClass.getProject()).getElementFactory().createType(entityClass);
        PsiClassType propertyType = relationshipType.isMany(false) ? containerType.createCollectionType((PsiElement)curClass, (PsiType)entityClassType, null) : entityClassType;
        this.ensurePropertyExists(curClass, attributeName, (PsiType)propertyType, accessMode, PsiAnnotation.EMPTY_ARRAY);
        return (PersistentRelationshipAttribute)results.get(0);
    }

    public void addCascadeVariants(Collection<String> cascadeVariants) {
        for (CascadeType type : CascadeType.values()) {
            cascadeVariants.add(type.getValue());
        }
    }

    public void addFetchVariants(Collection<String> fetchVariants) {
        for (LazyType type : LazyType.values()) {
            fetchVariants.add(type.getDisplayName());
        }
    }

    private boolean processDefiningAttributes(PairProcessor<HbmEmbeddedAttributeBase, AttributeManipulator> processor) {
        HbmEmbeddableImpl object = (HbmEmbeddableImpl)this.getManipulatorTarget();
        for (HbmEmbeddedAttributeBase attribute : object.getDefiningAttributes()) {
            AttributeManipulator manipulator;
            if (processor.process((Object)attribute, (Object)(manipulator = AttributeManipulator.getManipulator(attribute)))) continue;
            return false;
        }
        return true;
    }

    public PersistentAttribute addAttribute(String name, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        Ref firstRef = Ref.create(null);
        this.processDefiningAttributes((PairProcessor<HbmEmbeddedAttributeBase, AttributeManipulator>)((PairProcessor)(hbmEmbeddedAttributeBase, attributeManipulator) -> {
            HbmPropertyBase attrBase = attributeManipulator.addProperty((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
            if (attrBase != null) {
                attrBase.getName().setValue((Object)name);
                HibernateObjectManipulator.setColumns(attrBase, columns, true, this.isGenerateColumnProperties());
                if (firstRef.isNull()) {
                    firstRef.set((Object)attrBase);
                }
            }
            return true;
        }));
        PsiClass curClass = this.ensureClassExists();
        if (curClass == null) {
            return (PersistentAttribute)firstRef.get();
        }
        this.ensurePropertyExists(curClass, name, attributeType, accessType, PsiAnnotation.EMPTY_ARRAY);
        return (PersistentAttribute)firstRef.get();
    }

    public PersistentAttribute addIdAttribute(boolean compositeId, String name, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        throw new UnsupportedOperationException("addIdAttribute not supported");
    }

    public void setIdClass(String qualifiedName) throws IncorrectOperationException {
        throw new UnsupportedOperationException("setIdClass not supported");
    }

    public void addNamedQuery(String queryName, String queryText) {
        throw new UnsupportedOperationException("addNamedQuery not supported");
    }

    public static abstract class AttributeManipulator {
        public static final AttributeManipulator EMPTY = new AttributeManipulator(){};
        public static final AttributeManipulator COMPONENT = new AttributeManipulator(){

            @Override
            public boolean acceptsAttribute(HibernateAttributeType type) {
                return true;
            }

            @Override
            public HbmAny addAny(HbmEmbeddedAttributeBase attribute) {
                return ((HbmComponent)attribute).addAny();
            }

            @Override
            public HbmManyToOneBase addManyToOne(HbmEmbeddedAttributeBase attribute) {
                return ((HbmComponent)attribute).addManyToOne();
            }

            @Override
            public HbmOneToOne addOneToOne(HbmEmbeddedAttributeBase attribute) {
                return ((HbmComponent)attribute).addOneToOne();
            }

            @Override
            public HbmEmbeddedAttributeBase addComponent(HbmEmbeddedAttributeBase attribute) {
                return ((HbmComponent)attribute).addComponent();
            }

            @Override
            public HbmDynamicComponent addDynamicComponent(HbmEmbeddedAttributeBase attribute) {
                return ((HbmComponent)attribute).addDynamicComponent();
            }

            @Override
            public HbmContainer addContainer(HbmEmbeddedAttributeBase attribute, JavaContainerType containerType, boolean isPrimitive) {
                HbmComponent component = (HbmComponent)attribute;
                switch (containerType) {
                    case ARRAY: {
                        return isPrimitive ? component.addPrimitiveArray() : component.addArray();
                    }
                    case COLLECTION: {
                        return component.addSet();
                    }
                    case LIST: {
                        return component.addList();
                    }
                    case MAP: {
                        return component.addMap();
                    }
                    case SET: {
                        return component.addSet();
                    }
                }
                throw new AssertionError(containerType);
            }
        };
        public static final AttributeManipulator COMPOSITE_ELEMENT = new AttributeManipulator(){

            @Override
            public boolean acceptsAttribute(HibernateAttributeType type) {
                return type == HibernateAttributeType.ANY || type == HibernateAttributeType.COMPOSITE_ELEMENTS || type == HibernateAttributeType.PROPERTY || type == HibernateAttributeType.MANY_TO_ONE;
            }

            @Override
            public HbmAny addAny(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeElement)attribute).addAny();
            }

            @Override
            public HbmPropertyBase addProperty(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeElement)attribute).addProperty();
            }

            @Override
            public HbmManyToOneBase addManyToOne(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeElement)attribute).addManyToOne();
            }

            @Override
            public HbmEmbeddedAttributeBase addComponent(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeElement)attribute).addNestedCompositeElement();
            }
        };
        public static final AttributeManipulator COMPOSITE_ID = new AttributeManipulator(){

            @Override
            public boolean acceptsAttribute(HibernateAttributeType type) {
                return type == HibernateAttributeType.PROPERTY || type == HibernateAttributeType.MANY_TO_ONE;
            }

            @Override
            public HbmManyToOneBase addManyToOne(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeId)attribute).addManyToOne();
            }

            @Override
            public HbmPropertyBase addProperty(HbmEmbeddedAttributeBase attribute) {
                return ((HbmCompositeId)attribute).addProperty();
            }
        };
        public static final AttributeManipulator NESTED_COMPOSITE_ELEMENT = new AttributeManipulator(){

            @Override
            public boolean acceptsAttribute(HibernateAttributeType type) {
                return type == HibernateAttributeType.ANY || type == HibernateAttributeType.COMPOSITE_ELEMENTS || type == HibernateAttributeType.PROPERTY || type == HibernateAttributeType.MANY_TO_ONE;
            }

            @Override
            public HbmAny addAny(HbmEmbeddedAttributeBase attribute) {
                return ((HbmNestedCompositeElement)attribute).addAny();
            }

            @Override
            public HbmPropertyBase addProperty(HbmEmbeddedAttributeBase attribute) {
                return ((HbmNestedCompositeElement)attribute).addProperty();
            }

            @Override
            public HbmManyToOneBase addManyToOne(HbmEmbeddedAttributeBase attribute) {
                return ((HbmNestedCompositeElement)attribute).addManyToOne();
            }

            @Override
            public HbmEmbeddedAttributeBase addComponent(HbmEmbeddedAttributeBase attribute) {
                return ((HbmNestedCompositeElement)attribute).addNestedCompositeElement();
            }
        };

        public static AttributeManipulator getManipulator(HbmEmbeddedAttributeBase attribute) {
            if (attribute instanceof HbmComponent) {
                return COMPONENT;
            }
            if (attribute instanceof HbmCompositeElement) {
                return COMPOSITE_ELEMENT;
            }
            if (attribute instanceof HbmCompositeId) {
                return COMPOSITE_ID;
            }
            if (attribute instanceof HbmNestedCompositeElement) {
                return NESTED_COMPOSITE_ELEMENT;
            }
            return EMPTY;
        }

        public boolean acceptsAttribute(HibernateAttributeType type) {
            return false;
        }

        @Nullable
        public HbmAny addAny(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmPropertyBase addProperty(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmManyToOneBase addManyToOne(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmOneToOne addOneToOne(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmEmbeddedAttributeBase addComponent(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmDynamicComponent addDynamicComponent(HbmEmbeddedAttributeBase attribute) {
            return null;
        }

        @Nullable
        public HbmContainer addContainer(HbmEmbeddedAttributeBase attribute, JavaContainerType containerType, boolean isPrimitive) {
            return null;
        }
    }

    public static class MyDomAttributeAction
    extends ObjectManipulatorBase.MyAttributeAction<HibernateEmbeddableManipulator> {
        public MyDomAttributeAction(HibernateEmbeddableManipulator manipulator, HibernateAttributeType attributeType) {
            super((ObjectManipulatorBase)manipulator, (AttributeType)attributeType);
        }

        protected RelationshipType getRelationshipType() {
            return this.myAttributeType.getRelationshipType();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (this.getPresentation().isEnabled()) {
                this.getPresentation().setEnabled(this.acceptedBy((PersistentObject)((HibernateEmbeddableManipulator)this.getManipulator()).getManipulatorTarget()));
            }
        }

        private boolean acceptedBy(PersistentObject object) {
            for (HbmEmbeddedAttributeBase attribute : ((HbmEmbeddableImpl)((HibernateEmbeddableManipulator)this.getManipulator()).getManipulatorTarget()).getDefiningAttributes()) {
                if (!AttributeManipulator.getManipulator(attribute).acceptsAttribute((HibernateAttributeType)this.myAttributeType)) continue;
                return true;
            }
            return false;
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) throws IncorrectOperationException {
            if (result == null) {
                MyDomAttributeAction.$$$reportNull$$$0(0);
            }
            JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)this.myInfo.type);
            PsiClass attributeClass = this.myInfo.type instanceof PsiClassType ? ((PsiClassType)this.myInfo.type).resolve() : null;
            PsiType valueType = typeInfo.getValueType();
            PsiClass elementClass = valueType instanceof PsiClassType ? ((PsiClassType)valueType).resolve() : null;
            ((HibernateEmbeddableManipulator)this.getManipulator()).processDefiningAttributes((PairProcessor<HbmEmbeddedAttributeBase, AttributeManipulator>)((PairProcessor)(hbmEmbeddedAttributeBase, attributeManipulator) -> {
                HbmAttributeBase attribute;
                HbmContainer attributeContainer;
                boolean containerType = this.myAttributeType.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY);
                if (containerType) {
                    assert (typeInfo.containerType != null);
                    boolean isPrimitive = typeInfo.containerType == JavaContainerType.ARRAY && typeInfo.parameters.length == 1 && typeInfo.parameters[1] instanceof PsiPrimitiveType;
                    attributeContainer = attributeManipulator.addContainer((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase, typeInfo.containerType, isPrimitive);
                } else {
                    attributeContainer = null;
                }
                if (this.myAttributeType == HibernateAttributeType.ANY) {
                    attribute = attributeManipulator.addAny((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                } else if (this.myAttributeType == HibernateAttributeType.COMPONENT) {
                    HbmEmbeddedAttributeBase component = attributeManipulator.addComponent((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                    if (component != null) {
                        component.getClazz().setValue((Object)attributeClass);
                    }
                    attribute = component;
                } else if (this.myAttributeType == HibernateAttributeType.DYNAMIC_COMPONENT) {
                    attribute = attributeManipulator.addDynamicComponent((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                } else if (this.myAttributeType == HibernateAttributeType.COMPOSITE_ELEMENTS) {
                    if (attributeContainer != null) {
                        HbmCompositeElement compositeElement = attributeContainer.getCompositeElement();
                        compositeElement.getClazz().setValue((Object)elementClass);
                        attribute = compositeElement;
                    } else {
                        attribute = null;
                    }
                } else if (this.myAttributeType == HibernateAttributeType.ELEMENTS) {
                    if (attributeContainer != null) {
                        HbmElement element = attributeContainer.getElement();
                        element.getTypeAttr().setValue((Object)typeInfo.getValueType());
                        attribute = element;
                    } else {
                        attribute = null;
                    }
                } else if (this.myAttributeType == HibernateAttributeType.MANY_TO_ONE) {
                    attribute = attributeManipulator.addManyToOne((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                } else if (this.myAttributeType == HibernateAttributeType.ONE_TO_ONE) {
                    attribute = attributeManipulator.addOneToOne((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                } else if (this.myAttributeType == HibernateAttributeType.PROPERTY) {
                    attribute = attributeManipulator.addProperty((HbmEmbeddedAttributeBase)hbmEmbeddedAttributeBase);
                } else {
                    throw new AssertionError((Object)("invalid type: " + this.myAttributeType));
                }
                if (attribute != null) {
                    attribute.getName().setValue((Object)this.myInfo.name);
                    if (this.getRelationshipType() != null) {
                        DomElement parent;
                        ((HbmRelationAttributeBase)attribute).getTargetEntityClass().setValue((Object)(containerType ? elementClass : attributeClass));
                        if (this.myInfo.inverse && (parent = attribute.getParent()) instanceof HbmContainer && !(parent instanceof HbmPrimitiveArray) && !(parent instanceof HbmIdbag)) {
                            ((HbmContainer)parent).getInverse().setValue((Object)Boolean.TRUE);
                        }
                    }
                }
                return true;
            }));
            super.invokeAction(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/hibernate/model/manipulators/HibernateEmbeddableManipulator$MyDomAttributeAction", "invokeAction"));
        }
    }
}

