/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.model.xml.mapping.HbmPersistentObjectBase;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class NamedQueryNameConverter
extends Converter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        String prefix = NamedQueryNameConverter.getClassPrefix(context);
        return prefix != null && s != null && !s.startsWith(prefix) ? prefix + s : s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        String prefix = NamedQueryNameConverter.getClassPrefix(context);
        return prefix != null && s != null && s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    @Nullable
    private static String getClassPrefix(ConvertContext context) {
        HbmPersistentObjectBase object = (HbmPersistentObjectBase)context.getInvocationElement().getParentOfType(HbmPersistentObjectBase.class, true);
        if (object != null) {
            PsiClass psiClass = (PsiClass)object.getClazz().getValue();
            return psiClass != null ? psiClass.getQualifiedName() + "." : null;
        }
        return null;
    }
}

