/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.converters;

import com.intellij.hibernate.converters.HibernateConvertersRegistry;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.converters.ClassWithShortcutsResolvingConverter;
import com.intellij.hibernate.model.converters.GeneratorClassResolvingConverter;
import com.intellij.hibernate.model.enums.EntityModeType;
import com.intellij.hibernate.model.enums.HBM2DDLAutoType;
import com.intellij.hibernate.model.enums.ReleaseConnectionsType;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.mapping.HbmGenerator;
import com.intellij.hibernate.model.xml.mapping.HbmParam;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.javaee.model.JavaeePersistenceORMResolveConverters;
import com.intellij.javaee.model.xml.GenericNamedValueConverters;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ModuleContextProvider;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConverters
extends GenericNamedValueConverters {
    private final HibernateConvertersRegistry myConvertersRegistry = new HibernateConvertersRegistry();
    private final Map<HibernateVersion, Map<String, String>> SESSION_CONTEXT_MAP = new THashMap();
    private static final Condition<com.intellij.javaee.model.xml.persistence.Property> ourHibernateProviderCondition = domElement -> JpaUtil.isHibernate((JpaImplementationProvider)JpaUtil.findJpaProvider(null, (PersistencePackage)((PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true)), (boolean)false), null);

    public HibernateConverters() {
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "jta", "org.hibernate.context.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "thread", "org.hibernate.context.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_3_X, "managed", "org.hibernate.context.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_4_X, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_0, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "jta", "org.hibernate.context.internal.JTASessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        this.sessionContextMap(HibernateVersion.Hibernate_5_2, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        this.registerAllConverters();
    }

    private void sessionContextMap(HibernateVersion version, @NotNull String key, @NotNull String value) {
        if (key == null) {
            HibernateConverters.$$$reportNull$$$0(0);
        }
        if (value == null) {
            HibernateConverters.$$$reportNull$$$0(1);
        }
        if (!this.SESSION_CONTEXT_MAP.containsKey((Object)version)) {
            this.SESSION_CONTEXT_MAP.put(version, (Map<String, String>)new THashMap());
        }
        this.SESSION_CONTEXT_MAP.get((Object)version).put(key, value);
    }

    private void registerAllConverters() {
        ConverterManager converterManager = (ConverterManager)ApplicationManager.getApplication().getService(ConverterManager.class);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.driver_class", HibernateConverters.getPsiClassConverter("java.sql.Driver"));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.isolation", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.url", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.username", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.password", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.autocommit", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.pool_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.datasource", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jndi.class", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jndi.url", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "session_factory_name", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "default_schema", HibernateConverters.getSchemaConverter(converterManager));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "default_catalog", HibernateConverters.getCatalogConverter(converterManager));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "show_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "format_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "use_sql_comments", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "max_fetch_depth", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "default_batch_fetch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.use_streams_for_binary", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.use_scrollable_resultset", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.use_get_generated_keys", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.fetch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.batch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.batch_versioned_data", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "xml.output_stylesheet", HibernateConverters.getResourceConverter());
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.max_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.min_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.timeout", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.max_statements", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.acquire_increment", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "c3p0.idle_test_period", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "proxool.xml", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "proxool.properties", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "proxool.existing_pool", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "proxool.pool_alias", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "transaction.flush_before_completion", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.release_mode", (Converter)EnumConverter.createEnumConverter(ReleaseConnectionsType.class));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jta.UserTransaction", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.provider_configuration_file_resource_path", HibernateConverters.getFilePathConverter());
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.jndi", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.use_query_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.use_second_level_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.use_minimal_puts", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.region_prefix", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.use_structured_entries", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "generate_statistics", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "use_identifier_rollback", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "bytecode.use_reflection_optimizer", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "query.substitutions", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "hibernate.hbm2ddl.auto", (Converter)EnumConverter.createEnumConverter(HBM2DDLAutoType.class));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.wrap_result_sets", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "order_updates", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "default_entity_mode", (Converter)EnumConverter.createEnumConverter(EntityModeType.class));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jacc_context_id", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "query.jpaql_strict_compliance", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "connection.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.connection.ConnectionProvider", HibernateVersion.Hibernate_3_X).add("org.hibernate.service.jdbc.connections.spi.ConnectionProvider", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_5_2)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "dialect", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.dialect.Dialect", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.jdbc.Batcher", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "ejb.naming_strategy", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cfg.NamingStrategy", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "transaction.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionFactory", HibernateVersion.Hibernate_3_X).add("org.hibernate.engine.transaction.spi.TransactionFactory", HibernateVersion.Hibernate_4_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "transaction.manager_lookup_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionManagerLookup", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.CacheProvider", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "cache.query_cache_factory", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.spi.QueryCacheFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.cache.QueryCacheFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "query.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.hql.spi.QueryTranslatorFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.hql.QueryTranslatorFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "jdbc.sql_exception_converter", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.exception.SQLExceptionConverter", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "bytecode.provider", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.bytecode.spi.BytecodeProvider", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.bytecode.BytecodeProvider", HibernateVersion.Hibernate_3_X)));
        this.registrySessionContexClass();
        Condition<HbmParam> genAssignedCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.Assigned");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genAssignedCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genIncrementCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.IncrementGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "tables", HibernateConverters.getTableConverter(true, converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "identity_tables", HibernateConverters.getTableConverter(true, converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "target_column", HibernateConverters.getColumnConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genIncrementCondition, "column", HibernateConverters.getCatalogConverter(converterManager));
        Condition<HbmParam> genSequenceCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        Condition<HbmParam> genHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.TableHiLoGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "table", HibernateConverters.getTableConverter(false, converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genHiLoCondition, "max_lo", ResolvingConverter.INTEGER_CONVERTER);
        Condition<HbmParam> genSeqHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceHiLoGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "max_lo", ResolvingConverter.INTEGER_CONVERTER);
        Condition<HbmParam> genSelectCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SelectGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSelectCondition, "key", HibernateConverters.getPropertyConverter());
        Condition<HbmParam> genForeignCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.ForeignGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genForeignCondition, "property", HibernateConverters.getPropertyConverter());
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genForeignCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genSequenceIdentityCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceIdentityGenerator");
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        this.myConvertersRegistry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
    }

    private void registrySessionContexClass() {
        ClassWithShortcutsResolvingConverter converter = new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                String className = null;
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    if (version == HibernateVersion.Hibernate_3_X) {
                        className = "org.hibernate.context.CurrentSessionContext";
                        break;
                    }
                    if (version != HibernateVersion.Hibernate_4_X && version != HibernateVersion.Hibernate_5_0 && version != HibernateVersion.Hibernate_5_2) continue;
                    className = "org.hibernate.context.spi.CurrentSessionContext";
                    break;
                }
                return className;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                HibernateVersion version;
                Map<String, String> sessionContextMap;
                Module module = context.getModule();
                if (module != null && (sessionContextMap = HibernateConverters.this.SESSION_CONTEXT_MAP.get((Object)(version = HibernateUtil.getHibernateVersion(module)))) != null) {
                    Map<String, String> map = sessionContextMap;
                    if (map == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map;
                }
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/converters/HibernateConverters$1", "getShortcutsMap"));
            }
        };
        HibernateConverters.registerConfigProperty(this.myConvertersRegistry, "current_session_context_class", (Converter)converter);
    }

    @Nullable
    public Converter getValueConverter(DomElement domElement) {
        return this.myConvertersRegistry.getValueConverter(domElement);
    }

    @Nullable
    public Converter getNameConverter(DomElement domElement) {
        return this.myConvertersRegistry.getNameConverter(domElement);
    }

    @NotNull
    public <T extends DomElement> Map<String, Converter> getConverters(Class<T> domClass) {
        Map<String, Converter> map = this.myConvertersRegistry.getConverters(domClass);
        if (map == null) {
            HibernateConverters.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Nullable
    public <T extends DomElement> Converter getConverter(Class<T> domClass, String name) {
        return this.myConvertersRegistry.getConverter(domClass, name);
    }

    protected static void registerConfigProperty(HibernateConvertersRegistry registry, String name, Converter converter) {
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), name, converter);
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), "hibernate." + name, converter);
        registry.registerValueConverter(com.intellij.javaee.model.xml.persistence.Property.class, ourHibernateProviderCondition, name, converter);
        registry.registerValueConverter(com.intellij.javaee.model.xml.persistence.Property.class, ourHibernateProviderCondition, "hibernate." + name, converter);
    }

    private static Condition<HbmParam> createGeneratorTypeCondition(String generatorClassName) {
        return domElement -> {
            DomElement parent = domElement.getParent();
            if (!(parent instanceof HbmGenerator)) {
                return false;
            }
            HbmGenerator generator = (HbmGenerator)parent;
            String className = GeneratorClassResolvingConverter.getGeneratorClassName(generator.getClazz().getStringValue());
            return Objects.equals(className, generatorClassName);
        };
    }

    private static Converter getPsiClassConverter(String baseClassName) {
        return HibernateConverters.getPsiClassConverter(baseClassName, Collections.emptyMap());
    }

    private static Converter getPsiClassConverter(final String baseClassName, final Map<String, String> shortcutMap) {
        return new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                return baseClassName;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map map = shortcutMap;
                if (map == null) {
                    2.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/converters/HibernateConverters$2", "getShortcutsMap"));
            }
        };
    }

    private static Converter getConverter(final VersionsHelper helper) {
        return new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    String s = helper.getVersionsMap().get((Object)version);
                    if (s == null) continue;
                    return s;
                }
                return null;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    3.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/converters/HibernateConverters$3", "getShortcutsMap"));
            }
        };
    }

    private static Converter getSchemaConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SchemaResolver.class);
    }

    private static Converter getCatalogConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.CatalogResolver.class);
    }

    private static Converter getTableConverter(boolean isList, ConverterManager converterManager) {
        if (!isList) {
            return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.TableResolver.class);
        }
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getSequenceConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SequenceResolver.class);
    }

    private static Converter getColumnConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.ColumnResolver.class);
    }

    private static Converter getEntityConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getPropertyConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getResourceConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getFilePathConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/converters/HibernateConverters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/converters/HibernateConverters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConverters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sessionContextMap";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class VersionsHelper {
        Map<HibernateVersion, String> myMap = new HashMap<HibernateVersion, String>();

        private VersionsHelper() {
        }

        public Map<HibernateVersion, String> getVersionsMap() {
            return this.myMap;
        }

        public static VersionsHelper get(String s, HibernateVersion ... versions) {
            VersionsHelper c = new VersionsHelper();
            c.add(s, versions);
            return c;
        }

        public VersionsHelper add(HibernateVersion version, String s) {
            this.myMap.put(version, s);
            return this;
        }

        public VersionsHelper add(String s, HibernateVersion ... versions) {
            for (HibernateVersion version : versions) {
                this.myMap.put(version, s);
            }
            return this;
        }
    }
}

