/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.engine.HibernateConsole;
import com.intellij.hibernate.engine.HibernateEngine;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaConsoleProvider;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConsoleProvider
extends PersistenceConsoleProvider {
    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return project != null && facet != null && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateEngine.isAvailable(facet.getModule());
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (element == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(1);
        }
        if (!((file = element.getContainingFile()) instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateEngine.isAvailable(module)) {
            return false;
        }
        return JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element) != null;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        if (dataContext == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(2);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = project != null && facet != null && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateEngine.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        PersistencePackageAsVirtualFileImpl unitFile = PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyRunner(project, unitFile));
        HibernateConsoleProvider.addDefaultRunners(result, project, (PersistencePackagePointer)unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void addDefaultRunners(Collection<PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel queryText) {
        for (HibernateConsole console : HibernateConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)console.getTarget()).equals(unit)) continue;
            result.add((PersistenceConsoleProvider.Runner)new JpaConsoleProvider.MyConsoleRunner((JpaConsoleBase)console, (ScriptModel)queryText));
        }
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        QlScriptModel model;
        PsiFile file;
        if (element == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(6);
        }
        if (!((file = element.getContainingFile()) instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateEngine.isAvailable(module)) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit)) continue;
                ContainerUtil.addIfNotNull(unitFiles, (Object)PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet));
            }
        }
        if (unitFiles.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel((PsiFile)file, (QlFile)qlFile);
        if (model == null || model.statements().isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyQueryRunner(module.getProject(), unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            HibernateConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/HibernateConsoleProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/HibernateConsoleProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQueryRunner
    extends JpaConsoleProvider.MyQueryRunner {
        MyQueryRunner(Project project, List<PersistencePackagePointer> unitFiles, QlScriptModel model) {
            super(project, unitFiles, model);
        }

        public String getDisplayName() {
            return HibernateBundle.message("hibernate.console", new Object[0]);
        }

        public Icon getIcon() {
            return JavaUltimateIcons.Javaee.Hibernate;
        }

        public String getSubRunnersTitle() {
            return HibernateBundle.message("hibernate.console.session.factories.text", new Object[0]);
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            if (unit == null) {
                MyQueryRunner.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                MyQueryRunner.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyQueryRunner.$$$reportNull$$$0(2);
            }
            String text = (String)model.statements().transform(ScriptModelUtil.TO_TEXT).first();
            HibernateConsole console = (HibernateConsole)((Object)HibernateConsole.newConsole(unit).withRunConfiguration(configuration).withQuery((CharSequence)text).build());
            console.showConsole(false);
            if (console.beforeExecuteQueries((ScriptModel)model)) {
                console.executeQueries((ScriptModel)model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/hibernate/HibernateConsoleProvider$MyQueryRunner";
            objectArray[2] = "runInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRunner
    extends JpaConsoleProvider.MyRunner {
        private final PersistencePackageAsVirtualFileImpl myUnitFile;

        MyRunner(Project project, PersistencePackageAsVirtualFileImpl unitFile) {
            super(project, unitFile);
            this.myUnitFile = unitFile;
        }

        public String getDisplayName() {
            return HibernateBundle.message("hibernate.console", new Object[0]);
        }

        public Icon getIcon() {
            return JavaUltimateIcons.Javaee.Hibernate;
        }

        protected void runInner(@NotNull ConsoleRunConfiguration configuration) {
            if (configuration == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            ((HibernateConsole)((Object)HibernateConsole.newConsole((PersistencePackagePointer)this.myUnitFile).withRunConfiguration(configuration).build())).showConsole(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/HibernateConsoleProvider$MyRunner", "runInner"));
        }
    }
}

