/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/UseCompoundDrawableDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "studio.android.sdktools.lint-checks"})
public final class UseCompoundDrawableDetector
extends LayoutDetector {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"LinearLayout");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Element element2 = XmlUtils.getFirstSubTag((Node)element);
        if (element2 == null) {
            return;
        }
        Element first = element2;
        Element element3 = XmlUtils.getNextTag((Node)first);
        if (element3 == null) {
            return;
        }
        Element second = element3;
        if (XmlUtils.getNextTag((Node)second) != null) {
            return;
        }
        if (Intrinsics.areEqual((Object)first.getTagName(), (Object)"ImageView") && Intrinsics.areEqual((Object)second.getTagName(), (Object)"TextView") && UseCompoundDrawableDetector.Companion.canCombineImage(first) || Intrinsics.areEqual((Object)second.getTagName(), (Object)"ImageView") && Intrinsics.areEqual((Object)first.getTagName(), (Object)"TextView") && UseCompoundDrawableDetector.Companion.canCombineImage(second)) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
                return;
            }
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"This tag and its children can be replaced by one `<TextView/>` and a compound drawable", null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(UseCompoundDrawableDetector.class, Scope.RESOURCE_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.PERFORMANCE;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UseCompoundDrawables", (String)"Node can be replaced by a `TextView` with compound drawables", (String)"\n                A `LinearLayout` which contains an `ImageView` and a `TextView` can be more \\\n                efficiently handled as a compound drawable (a single TextView, using the \\\n                `drawableTop`, `drawableLeft`, `drawableRight` and/or `drawableBottom` \\\n                attributes to draw one or more images adjacent to the text).\n\n                If the two widgets are offset from each other with margins, this can be \\\n                replaced with a `drawablePadding` attribute.\n\n                There's a lint quickfix to perform this conversion in the Eclipse plugin.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/UseCompoundDrawableDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "canCombineImage", "", "image", "Lorg/w3c/dom/Element;", "studio.android.sdktools.lint-checks"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canCombineImage(Element image) {
            if (image.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) return false;
            if (image.hasAttributeNS("http://schemas.android.com/apk/res/android", "clickable")) return false;
            if (image.hasAttributeNS("http://schemas.android.com/apk/res/android", "focusable")) {
                return false;
            }
            String scaleType = image.getAttributeNS("http://schemas.android.com/apk/res/android", "scaleType");
            if (scaleType == null) return true;
            CharSequence charSequence = scaleType;
            boolean bl = false;
            if (charSequence.length() != 0) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

