/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.MissingClassDetector$WhenMappings;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.kotlin.KotlinUClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "()V", "checkedClasses", "", "", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkClassReference", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "pkg", "className", "classNameNode", "Lorg/w3c/dom/Node;", "element", "Lorg/w3c/dom/Element;", "requireInstantiatable", "expectedParent", "checkExpectedParent", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "nameNode", "cls", "Lcom/intellij/psi/PsiClass;", "checkInnerClassReference", "checkInstantiatable", "fqcn", "getApplicableElements", "", "getRefLocation", "Lcom/android/tools/lint/detector/api/Location;", "hasImplicitDefaultConstructor", "psiClass", "reportMissing", "location", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Companion", "studio.android.sdktools.lint-checks"})
public final class MissingClassDetector
extends LayoutDetector
implements ClassScanner {
    private Map<String, Boolean> checkedClasses;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue INSTANTIATABLE;
    @JvmField
    @NotNull
    public static final Issue INNERCLASS;
    public static final Companion Companion;

    @Nullable
    public Collection<String> getApplicableElements() {
        return LayoutDetector.ALL;
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.TRANSITION;
    }

    /*
     * Unable to fully structure code
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        block44: {
            block43: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                tag = element.getTagName();
                v0 = context.getResourceFolderType();
                if (v0 != null) break block43;
                if (!Intrinsics.areEqual((Object)"application", (Object)tag) && !Intrinsics.areEqual((Object)"activity", (Object)tag) && !Intrinsics.areEqual((Object)"service", (Object)tag) && !Intrinsics.areEqual((Object)"receiver", (Object)tag) && !Intrinsics.areEqual((Object)"provider", (Object)tag)) break block44;
                v1 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (v1 == null) {
                    return;
                }
                attr = v1;
                pkg = context.getProject().getPackage();
                v2 = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"attr.value");
                v3 = attr;
                v4 = tag;
                if (v4 == null) ** GOTO lbl-1000
                var6_15 = v4;
                tmp = -1;
                switch (var6_15.hashCode()) {
                    case -1655966961: {
                        if (!var6_15.equals("activity")) break;
                        tmp = 1;
                        break;
                    }
                    case -808719889: {
                        if (!var6_15.equals("receiver")) break;
                        tmp = 2;
                        break;
                    }
                    case 1554253136: {
                        if (!var6_15.equals("application")) break;
                        tmp = 3;
                        break;
                    }
                    case -987494927: {
                        if (!var6_15.equals("provider")) break;
                        tmp = 4;
                        break;
                    }
                    case 1984153269: {
                        if (!var6_15.equals("service")) break;
                        tmp = 5;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v5 = "android.app.Activity";
                        break;
                    }
                    case 5: {
                        v5 = "android.app.Service";
                        break;
                    }
                    case 2: {
                        v5 = "android.content.BroadcastReceiver";
                        break;
                    }
                    case 4: {
                        v5 = "android.content.ContentProvider";
                        break;
                    }
                    case 3: {
                        v5 = "android.app.Application";
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v5 = null;
                    }
                }
                this.checkClassReference(context, pkg, v2, v3, element, true, v5);
                ** break;
            }
            switch (MissingClassDetector$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"string") && SdkUtils.endsWith((CharSequence)context.file.getPath(), (CharSequence)"analytics.xml")) {
                        v6 = element.getAttributeNode("name");
                        if (v6 == null) {
                            return;
                        }
                        attr = v6;
                        v7 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"attr.value");
                        MissingClassDetector.checkClassReference$default(this, context, null, v7, attr, element, false, null, 96, null);
                    }
                    break;
                }
                case 2: {
                    v8 = tag;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"tag");
                    if (StringsKt.indexOf$default((CharSequence)v8, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                        MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
                        v9 = element.getAttributeNode("class");
                        if (v9 == null) {
                            return;
                        }
                        attr = v9;
                        v10 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"attr.value");
                        MissingClassDetector.checkClassReference$default(this, context, null, v10, attr, element, false, LintClient.Companion.isStudio() != false ? null : "android.view.View", 32, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"fragment")) {
                        v11 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (v11 == null) {
                            v11 = element.getAttributeNode("class");
                        }
                        if (v11 == null) {
                            return;
                        }
                        attr = v11;
                        v12 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"attr.value");
                        this.checkClassReference(context, null, v12, attr, element, true, "android.app.Fragment");
                    }
                    break;
                }
                case 3: {
                    v13 = tag;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"tag");
                    if (StringsKt.indexOf$default((CharSequence)v13, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                        MissingClassDetector.checkClassReference$default(this, context, null, tag, element, element, false, null, 96, null);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"drawable")) {
                        v14 = element.getAttributeNode("class");
                        if (v14 == null) {
                            return;
                        }
                        attr = v14;
                        v15 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"attr.value");
                        MissingClassDetector.checkClassReference$default(this, context, null, v15, attr, element, false, "android.graphics.drawable.Drawable", 32, null);
                    }
                    break;
                }
                case 4: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"transition") || Intrinsics.areEqual((Object)tag, (Object)"pathMotion")) {
                        v16 = element.getAttributeNode("class");
                        if (v16 == null) {
                            return;
                        }
                        attr = v16;
                        expectedParent = Intrinsics.areEqual((Object)tag, (Object)"transition") != false ? "android.transition.Transition" : "android.transition.PathMotion";
                        v17 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"attr.value");
                        MissingClassDetector.checkClassReference$default(this, context, null, v17, attr, element, false, expectedParent, 32, null);
                    }
                    break;
                }
                case 5: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"header")) {
                        v18 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
                        if (v18 == null) {
                            return;
                        }
                        attr = v18;
                        v19 = attr.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"attr.value");
                        this.checkClassReference(context, null, v19, attr, element, true, "android.app.Fragment");
                    }
                    break;
                }
                case 6: {
                    if (Intrinsics.areEqual((Object)tag, (Object)"item")) {
                        v20 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionViewClass");
                        if (v20 == null) {
                            v20 = view = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionViewClass");
                        }
                        if (view != null) {
                            v21 = view.getValue();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"view.value");
                            MissingClassDetector.checkClassReference$default(this, context, null, v21, view, element, false, "android.view.View", 32, null);
                        }
                        if ((v22 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionProviderClass")) == null) {
                            v22 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionProviderClass");
                        }
                        if (v22 == null) {
                            return;
                        }
                        provider = v22;
                        v23 = provider.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"provider.value");
                        MissingClassDetector.checkClassReference$default(this, context, null, v23, provider, element, false, null, 96, null);
                    }
                    break;
                }
            }
lbl161:
            // 11 sources

        }
    }

    private final void checkClassReference(XmlContext context, String pkg, String className, Node classNameNode, Element element, boolean requireInstantiatable, String expectedParent) {
        CharSequence charSequence = className;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        String fqcn = null;
        int dotIndex = StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? pkg + className : pkg + '.' + className;
        } else {
            fqcn = className;
        }
        if (StringsKt.startsWith$default((String)fqcn, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqcn, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            return;
        }
        Boolean ok = this.checkedClasses.get(fqcn);
        if (ok == null) {
            UastParser parser = context.getClient().getUastParser(context.getMainProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass cls = evaluator.findClass(StringsKt.replace$default((String)fqcn, (char)'$', (char)'.', (boolean)false, (int)4, null));
            if (cls != null) {
                ok = true;
                if (requireInstantiatable) {
                    this.checkInstantiatable(context, evaluator, cls, fqcn, classNameNode);
                }
                this.checkInnerClassReference(context, cls, className, classNameNode, element);
                if (expectedParent != null) {
                    this.checkExpectedParent(context, evaluator, classNameNode, cls, expectedParent);
                }
            } else {
                ok = false;
            }
            this.checkedClasses.put(fqcn, ok);
        }
        if (Intrinsics.areEqual((Object)ok, (Object)false)) {
            Location location = this.getRefLocation(context, classNameNode);
            this.reportMissing(location, fqcn, (Context)context);
        }
    }

    static /* synthetic */ void checkClassReference$default(MissingClassDetector missingClassDetector, XmlContext xmlContext, String string, String string2, Node node, Element element, boolean bl, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        missingClassDetector.checkClassReference(xmlContext, string, string2, node, element, bl, string3);
    }

    private final void checkExpectedParent(XmlContext context, JavaEvaluator evaluator, Node nameNode, PsiClass cls, String expectedParent) {
        if (!evaluator.inheritsFrom(cls, expectedParent, false)) {
            if (Intrinsics.areEqual((Object)expectedParent, (Object)"android.app.Fragment")) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.oldName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.oldName()");
                this.checkExpectedParent(context, evaluator, nameNode, cls, string);
                return;
            }
            if (Intrinsics.areEqual((Object)expectedParent, (Object)SdkConstants.CLASS_V4_FRAGMENT.oldName())) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.newName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.newName()");
                this.checkExpectedParent(context, evaluator, nameNode, cls, string);
                return;
            }
            String message2 = StringsKt.contains$default((CharSequence)expectedParent, (CharSequence)"Fragment", (boolean)false, (int)2, null) ? '`' + cls.getName() + "` must be a fragment" : '`' + cls.getName() + "` must extend " + expectedParent;
            Context.report$default((Context)context, (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message2, null, (int)8, null);
        }
    }

    private final void checkInnerClassReference(XmlContext context, PsiClass cls, String className, Node nameNode, Element element) {
        String full;
        String name = cls.getName();
        if (cls.getContainingClass() == null || name == null || StringsKt.contains$default((CharSequence)className, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return;
        }
        String string = Lint.getInternalName((PsiClass)cls);
        if (string == null || (string = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null)) == null) {
            return;
        }
        String string2 = full = string;
        int n = full.length() - className.length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String fixed = string4;
        String message2 = "Use '$' instead of '.' for inner classes; replace \"" + className + "\" with \"" + fixed + '\"';
        Location location = this.getRefLocation(context, nameNode);
        LintFix fix = LintFix.create().replace().text(className).with(fixed).autoFix().build();
        context.report(INNERCLASS, (Node)element, location, message2, fix);
    }

    private final void checkInstantiatable(XmlContext context, JavaEvaluator evaluator, PsiClass cls, String fqcn, Node nameNode) {
        if (evaluator.isPrivate((PsiModifierListOwner)cls)) {
            String message2 = "This class should be public (`" + fqcn + "`)";
            Context.report$default((Context)context, (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message2, null, (int)8, null);
        } else if (cls.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)cls)) {
            String message3 = "This inner class should be static (`" + fqcn + "`)";
            Context.report$default((Context)context, (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message3, null, (int)8, null);
        } else {
            PsiMethod[] constructors;
            PsiMethod[] psiMethodArray = cls.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"cls.constructors");
            PsiMethod[] psiMethodArray2 = constructors = psiMethodArray;
            int n = 0;
            if (psiMethodArray2.length == 0 && this.hasImplicitDefaultConstructor(cls)) {
                return;
            }
            PsiMethod[] psiMethodArray3 = cls.getConstructors();
            int n2 = psiMethodArray3.length;
            for (n = 0; n < n2; ++n) {
                PsiMethod constructor;
                PsiMethod psiMethod = constructor = psiMethodArray3[n];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"constructor");
                PsiParameterList psiParameterList = psiMethod.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"constructor.parameterList");
                if (!psiParameterList.isEmpty()) continue;
                if (evaluator.isPrivate((PsiModifierListOwner)constructor)) {
                    String message4 = "The default constructor must be public in `" + fqcn + '`';
                    Context.report$default((Context)context, (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message4, null, (int)8, null);
                    return;
                }
                return;
            }
            String message5 = "This class should provide a default constructor (a public constructor with no arguments) (`" + fqcn + "`)";
            Context.report$default((Context)context, (Issue)INSTANTIATABLE, (Location)this.getRefLocation(context, nameNode), (String)message5, null, (int)8, null);
        }
    }

    private final Location getRefLocation(XmlContext context, Node nameNode) {
        return nameNode instanceof Attr ? context.getValueLocation((Attr)nameNode) : context.getLocation(nameNode);
    }

    private final boolean hasImplicitDefaultConstructor(PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass instanceof KotlinUClass && ((KotlinUClass)psiClass).getSourcePsi() == null) {
            return false;
        }
        PsiMethod[] psiMethodArray = psiClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"psiClass.constructors");
        PsiMethod[] psiMethodArray2 = constructors = psiMethodArray;
        boolean bl = false;
        if (psiMethodArray2.length == 0 && !psiClass.isInterface() && !psiClass.isAnnotationType() && !psiClass.isEnum()) {
            if (PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
                return true;
            }
            if (psiClass.hasModifierProperty("final") && !psiClass.hasModifierProperty("abstract") && psiClass.hasModifierProperty("public")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMissing(Location location, String fqcn, Context context) {
        String string;
        File parentFile = location.getFile().getParentFile();
        if (parentFile != null) {
            ResourceFolderType resourceFolderType;
            String parent = parentFile.getName();
            ResourceFolderType resourceFolderType2 = resourceFolderType = ResourceFolderType.getFolderType((String)parent);
            if (resourceFolderType2 == null) {
                string = "manifest";
            } else {
                switch (MissingClassDetector$WhenMappings.$EnumSwitchMapping$1[resourceFolderType2.ordinal()]) {
                    case 1: {
                        string = "layout file";
                        break;
                    }
                    case 2: {
                        string = "preference header file";
                        break;
                    }
                    case 3: {
                        string = "analytics file";
                        break;
                    }
                    default: {
                        void type;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = type.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.getName()");
                        String string3 = string2;
                        Locale locale = Locale.US;
                        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                        Locale locale2 = locale;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.toLowerCase(locale2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                        String string6 = string5;
                        string = stringBuilder2.append(string6).append(" file").toString();
                        break;
                    }
                }
            }
        } else {
            string = "the manifest";
        }
        String target2 = string;
        String message2 = "Class referenced in the " + target2 + ", `" + fqcn + "`, was not found in the project or the libraries";
        Context.report$default((Context)context, (Issue)MISSING, (Location)location, (String)message2, null, (int)8, null);
    }

    public MissingClassDetector() {
        Map map;
        MissingClassDetector missingClassDetector = this;
        boolean bl = false;
        missingClassDetector.checkedClasses = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(MissingClassDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE});
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        String string = "http://developer.android.com/guide/topics/manifest/manifest-intro.html";
        Severity severity = Severity.ERROR;
        int n = 8;
        Category category = Category.CORRECTNESS;
        MISSING = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MissingClass", (String)"Missing registered class", (String)"\n                    If a class is referenced in the manifest or in a layout file, it must \\\n                    also exist in the project (or in one of the libraries included by the \\\n                    project. This check helps uncover typos in registration names, or \\\n                    attempts to rename or move classes without updating the XML references \n                    properly.\n                    ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        string = Severity.FATAL;
        int n2 = 6;
        String string2 = null;
        category = Category.CORRECTNESS;
        INSTANTIATABLE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"Instantiatable", (String)"Registered class is not instantiatable", (String)"\n                    Activities, services, broadcast receivers etc. registered in the \\\n                    manifest file (or for custom views, in a layout file) must be \\\n                    \"instantiatable\" by the system, which means that the class must \\\n                    be public, it must have an empty public constructor, and if it's an \\\n                    inner class, it must be a static inner class.", (Implementation)implementation, string2, (Category)category, (int)n2, (Severity)string, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        string = Severity.WARNING;
        n2 = 3;
        string2 = null;
        category = Category.CORRECTNESS;
        INNERCLASS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"InnerclassSeparator", (String)"Inner classes should use `$` rather than `.`", (String)"\n                    When you reference an inner class in a manifest file, you must use '$' \\\n                    instead of '.' as the separator character, i.e. Outer$Inner instead of \\\n                    Outer.Inner.\n\n                    (If you get this warning for a class which is not actually an inner class, \\\n                    it's because you are using uppercase characters in your package name, which \\\n                    is not conventional.)\n                    ", (Implementation)implementation, string2, (Category)category, (int)n2, (Severity)string, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "INNERCLASS", "Lcom/android/tools/lint/detector/api/Issue;", "INSTANTIATABLE", "MISSING", "studio.android.sdktools.lint-checks"})
    public static final class Companion {
        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

