/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.StringHelper;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "JavaVisitor", "KotlinVisitor", "studio.android.sdktools.lint-checks"})
public final class InteroperabilityDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final boolean IGNORE_DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue NO_HARD_KOTLIN_KEYWORDS;
    @JvmField
    @NotNull
    public static final Issue LAMBDA_LAST;
    @JvmField
    @NotNull
    public static final Issue PLATFORM_NULLNESS;
    @JvmField
    @NotNull
    public static final Issue KOTLIN_PROPERTY;
    public static final Issues Issues;

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UFile uFile = context.getUastFile();
        if (Lint.isKotlin((PsiElement)((PsiElement)(uFile != null ? uFile.getPsi() : null)))) {
            boolean checkNullness = context.isEnabled(PLATFORM_NULLNESS);
            if (checkNullness) {
                return new KotlinVisitor(context);
            }
            return null;
        }
        return new JavaVisitor(context);
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UMethod.class, UField.class});
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(InteroperabilityDetector.class, Scope.JAVA_FILE_SCOPE);
        IGNORE_DEPRECATED = Intrinsics.areEqual((Object)"true", (Object)System.getenv("ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED")) || Intrinsics.areEqual((Object)"true", (Object)System.getProperty("lint.nullness.ignore-deprecated"));
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl2 = false;
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        String string = "https://android.github.io/kotlin-guides/interop.html#no-hard-keywords";
        NO_HARD_KOTLIN_KEYWORDS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NoHardKeywords", (String)"No Hard Kotlin Keywords", (String)"\n            Do not use Kotlin\u2019s hard keywords as the name of methods or fields.\n            These require the use of backticks to escape when calling from Kotlin.\n            Soft keywords, modifier keywords, and special identifiers are allowed.\n\n            For example, Mockito\u2019s `when` function requires backticks when used from Kotlin:\n\n                val callable = Mockito.mock(Callable::class.java)\n                Mockito.\\`when\\`(callable.call()).thenReturn(/* \u2026 */)\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3584, null);
        collection = null;
        enumSet = null;
        bl = null;
        implementation = IMPLEMENTATION;
        bl2 = false;
        severity = Severity.WARNING;
        n = 6;
        category = Category.INTEROPERABILITY_KOTLIN;
        string = "https://android.github.io/kotlin-guides/interop.html#lambda-parameters-last";
        LAMBDA_LAST = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"LambdaLast", (String)"Lambda Parameters Last", (String)"\n            To improve calling this code from Kotlin,\n            parameter types eligible for SAM conversion should be last.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3584, null);
        collection = null;
        enumSet = null;
        bl = null;
        implementation = IMPLEMENTATION;
        bl2 = false;
        severity = Severity.WARNING;
        n = 6;
        category = Category.INTEROPERABILITY_KOTLIN;
        string = "https://android.github.io/kotlin-guides/interop.html#nullability-annotations";
        PLATFORM_NULLNESS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UnknownNullness", (String)"Unknown nullness", (String)"\n            To improve referencing this code from Kotlin, consider adding\n            explicit nullness information here with either `@NonNull` or `@Nullable`.\n\n            You can set the environment variable\n                `ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED=true`\n            if you want lint to ignore classes and members that have been annotated with\n            `@Deprecated`.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3584, null);
        collection = null;
        enumSet = null;
        bl = null;
        implementation = IMPLEMENTATION;
        bl2 = false;
        severity = Severity.WARNING;
        n = 6;
        category = Category.INTEROPERABILITY_KOTLIN;
        string = "https://android.github.io/kotlin-guides/interop.html#property-prefixes";
        KOTLIN_PROPERTY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"KotlinPropertyAccess", (String)"Kotlin Property Access", (String)"\n            For a method to be represented as a property in Kotlin, strict \u201cbean\u201d-style prefixing must be used.\n\n            Accessor methods require a \u2018get\u2019 prefix or for boolean-returning methods an \u2018is\u2019 prefix can be used.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3584, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "hasNullnessAnnotation", "", "node", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/uast/UAnnotated;", "reportMissingExplicitType", "", "Lorg/jetbrains/uast/UElement;", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "studio.android.sdktools.lint-checks"})
    public static final class KotlinVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node) && node.getReturnTypeReference() == null) {
                PsiType psiType = node.getReturnType();
                if (psiType == null) {
                    return;
                }
                PsiType type = psiType;
                if (type instanceof PsiPrimitiveType) {
                    return;
                }
                if (this.hasNullnessAnnotation((UAnnotated)node)) {
                    return;
                }
                UExpression uExpression = node.getUastBody();
                if (!(uExpression instanceof UBlockExpression)) {
                    uExpression = null;
                }
                UBlockExpression uBlockExpression = (UBlockExpression)uExpression;
                if (uBlockExpression == null) {
                    return;
                }
                UBlockExpression body = uBlockExpression;
                List expressions = body.getExpressions();
                if (expressions.size() == 1) {
                    Object e = expressions.get(0);
                    if (!(e instanceof UReturnExpression)) {
                        e = null;
                    }
                    UReturnExpression uReturnExpression = (UReturnExpression)e;
                    if (uReturnExpression == null) {
                        return;
                    }
                    UReturnExpression statement = uReturnExpression;
                    UExpression uExpression2 = statement.getReturnExpression();
                    if (!(uExpression2 instanceof UReferenceExpression)) {
                        uExpression2 = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression2;
                    if (uReferenceExpression == null) {
                        return;
                    }
                    UReferenceExpression expression = uReferenceExpression;
                    PsiElement psiElement = expression.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (Lint.isKotlin((PsiElement)resolved)) {
                        return;
                    }
                    if (resolved instanceof PsiModifierListOwner && this.hasNullnessAnnotation((PsiModifierListOwner)resolved)) {
                        return;
                    }
                    this.reportMissingExplicitType((UElement)node);
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node) && node.getTypeReference() == null) {
                PsiType psiType = node.getType();
                if (psiType == null) {
                    return;
                }
                PsiType type = psiType;
                if (type instanceof PsiPrimitiveType) {
                    return;
                }
                if (this.hasNullnessAnnotation((UAnnotated)node)) {
                    return;
                }
                UExpression uExpression = node.getUastInitializer();
                if (!(uExpression instanceof UReferenceExpression)) {
                    uExpression = null;
                }
                UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression;
                if (uReferenceExpression == null) {
                    return;
                }
                UReferenceExpression expression = uReferenceExpression;
                PsiElement psiElement = expression.resolve();
                if (psiElement == null) {
                    return;
                }
                PsiElement resolved = psiElement;
                if (Lint.isKotlin((PsiElement)resolved)) {
                    return;
                }
                this.reportMissingExplicitType((UElement)node);
            }
        }

        private final void reportMissingExplicitType(UElement node) {
            JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)node, (Location)this.context.getNameLocation(node), (String)"Should explicitly declare type here since implicit type does not specify nullness", null, (int)16, null);
        }

        private final boolean hasNullnessAnnotation(UAnnotated node) {
            for (UAnnotation annotation : this.context.getEvaluator().getAllAnnotations(node, false)) {
                String name;
                if (annotation.getQualifiedName() == null) {
                    continue;
                }
                if (!Issues.isNullableAnnotation(name) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }

        private final boolean hasNullnessAnnotation(PsiModifierListOwner node) {
            for (PsiAnnotation annotation : this.context.getEvaluator().getAllAnnotations(node, false)) {
                String name;
                if (annotation.getQualifiedName() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"annotation.qualifiedName ?: continue");
                if (!Issues.isNullableAnnotation(name) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public KotlinVisitor(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\"\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkForKeywords", "", "checkLambdaLast", "checkNullness", "checkPropertyAccess", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "nonNullAnnotation", "", "nullableAnnotation", "ensureLambdaLastParameter", "", "method", "Lorg/jetbrains/uast/UMethod;", "ensureNonKeyword", "name", "node", "Lorg/jetbrains/uast/UDeclaration;", "typeLabel", "ensureNullnessKnown", "type", "Lcom/intellij/psi/PsiType;", "ensureValidProperty", "setter", "methodName", "getNonNullAnnotation", "getNullableAnnotation", "getPropertyLocation", "Lcom/android/tools/lint/detector/api/Location;", "location1", "Lcom/intellij/psi/PsiMethod;", "location2", "hasSetter", "cls", "Lorg/jetbrains/uast/UClass;", "setterName", "initializeAnnotationNames", "isEqualsParameter", "isFunctionalInterface", "isLikelySetter", "isToStringMethod", "isTypeVariableReference", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "studio.android.sdktools.lint-checks"})
    public static final class JavaVisitor
    extends UElementHandler {
        private final boolean checkForKeywords;
        private final boolean checkNullness;
        private final boolean checkLambdaLast;
        private final boolean checkPropertyAccess;
        private String nonNullAnnotation;
        private String nullableAnnotation;
        @NotNull
        private final JavaContext context;

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                String methodName = node.getName();
                if (this.checkForKeywords) {
                    this.ensureNonKeyword(methodName, (UDeclaration)node, "method");
                }
                if (this.checkPropertyAccess && this.isLikelySetter(methodName, node)) {
                    this.ensureValidProperty(node, methodName);
                }
                if (this.checkLambdaLast) {
                    this.ensureLambdaLastParameter(node);
                }
                if (this.checkNullness) {
                    PsiType type = node.getReturnType();
                    if (type != null) {
                        this.ensureNullnessKnown((UDeclaration)node, type);
                    }
                    for (UParameter parameter : node.getUastParameters()) {
                        this.ensureNullnessKnown((UDeclaration)parameter, parameter.getType());
                    }
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                if (this.checkForKeywords) {
                    String string = node.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.name");
                    this.ensureNonKeyword(string, (UDeclaration)node, "field");
                }
                if (this.checkNullness) {
                    this.ensureNullnessKnown((UDeclaration)node, node.getType());
                }
            }
        }

        private final boolean isLikelySetter(String methodName, UMethod node) {
            return StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null) && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && node.getUastParameters().size() == 1 && this.context.getEvaluator().isPublic((PsiModifierListOwner)node) && !this.context.getEvaluator().isStatic((PsiModifierListOwner)node);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void ensureValidProperty(UMethod setter, String methodName) {
            String string;
            String matchingName;
            JvmParameter[] jvmParameterArray;
            int n;
            int n2;
            PsiMethod[] element$iv2;
            int n3;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)setter));
            if (uClass == null) return;
            UClass cls = uClass;
            String string2 = methodName;
            int n4 = 3;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String propertySuffix = string4;
            String propertyName = StringHelper.usLocaleDecapitalize((String)propertySuffix);
            String getterName1 = "get" + propertySuffix;
            String getterName2 = "is" + propertySuffix;
            String badGetterName = "has" + propertySuffix;
            PsiMethod getter = null;
            PsiMethod[] badGetter = null;
            UMethod[] uMethodArray = cls.getMethods();
            boolean $i$f$forEach = false;
            UMethod[] uMethodArray2 = uMethodArray;
            int n5 = uMethodArray2.length;
            for (n3 = 0; n3 < n5; ++n3) {
                PsiMethod[] it = element$iv2 = uMethodArray2[n3];
                n2 = 0;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.getParameters(), (String)"it.parameters");
                n = 0;
                if (!(jvmParameterArray.length == 0)) continue;
                String name = it.getName();
                if (Intrinsics.areEqual((Object)name, (Object)getterName1) || Intrinsics.areEqual((Object)name, (Object)getterName2)) {
                    getter = (PsiMethod)it;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)badGetterName) && !Intrinsics.areEqual((Object)name, (Object)propertyName) && !StringsKt.endsWith$default((String)name, (String)propertySuffix, (boolean)false, (int)2, null) || !this.context.getEvaluator().isPublic((PsiModifierListOwner)it) || it.isConstructor()) continue;
                UParameter uParameter = (UParameter)CollectionsKt.firstOrNull((List)setter.getUastParameters());
                if (!Intrinsics.areEqual((Object)it.getReturnType(), (Object)(uParameter != null ? uParameter.getType() : null))) continue;
                badGetter = it;
            }
            if (getter == null) {
                Unit unit;
                UClass uClass2 = cls.getSuperClass();
                if (uClass2 != null) {
                    PsiMethod inherited;
                    UClass uClass3 = uClass2;
                    $i$f$forEach = false;
                    boolean bl2 = false;
                    UClass superClass = uClass3;
                    boolean bl3 = false;
                    element$iv2 = superClass.findMethodsByName(getterName1, true);
                    int it = element$iv2.length;
                    for (n2 = 0; n2 < it; ++n2) {
                        PsiMethod psiMethod = inherited = element$iv2[n2];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"inherited");
                        PsiParameterList psiParameterList = psiMethod.getParameterList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"inherited.parameterList");
                        if (psiParameterList.getParametersCount() != 0) continue;
                        getter = inherited;
                        break;
                    }
                    if (getter == null) {
                        element$iv2 = superClass.findMethodsByName(getterName2, true);
                        it = element$iv2.length;
                        for (n2 = 0; n2 < it; ++n2) {
                            PsiMethod psiMethod = inherited = element$iv2[n2];
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"inherited");
                            PsiParameterList psiParameterList = psiMethod.getParameterList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"inherited.parameterList");
                            if (psiParameterList.getParametersCount() != 0) continue;
                            getter = inherited;
                            break;
                        }
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (getter != null && !(getter instanceof PsiCompiledElement)) {
                PsiMethod psiMethod = getter;
                if (psiMethod == null) {
                    Intrinsics.throwNpe();
                }
                PsiMethod psiMethod2 = psiMethod;
                if (!this.context.getEvaluator().isPublic((PsiModifierListOwner)psiMethod2)) {
                    String message2 = "This getter should be public such that `" + propertyName + "` can " + "be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location = this.context.getNameLocation((PsiElement)psiMethod2);
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)((PsiElement)psiMethod2), (Location)location, (String)message2, null, (int)16, null);
                    return;
                }
                if (this.context.getEvaluator().isStatic((PsiModifierListOwner)psiMethod2)) {
                    PsiElement psiElement;
                    PsiElement staticElement = null;
                    PsiModifierList psiModifierList = psiMethod2.getModifierList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"getter.modifierList");
                    PsiModifierList modifierList = psiModifierList;
                    if (modifierList.hasExplicitModifier("static")) {
                        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                            staticElement = child;
                            break;
                        }
                    }
                    Location location = staticElement != null ? this.context.getLocation(staticElement) : this.context.getNameLocation((PsiElement)psiMethod2);
                    String message3 = "This getter should not be static such that `" + propertyName + "` can " + "be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Object object = location.getSource();
                    if (!(object instanceof PsiElement)) {
                        object = null;
                    }
                    if ((psiElement = (PsiElement)object) == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location, (String)message3, null, (int)16, null);
                    return;
                }
                PsiType setterParameterType = ((UParameter)CollectionsKt.first((List)setter.getUastParameters())).getType();
                if (Intrinsics.areEqual((Object)setterParameterType, (Object)psiMethod2.getReturnType()) ^ true && !this.hasSetter(cls, psiMethod2.getReturnType(), setter.getName()) && !this.isTypeVariableReference(setterParameterType)) {
                    PsiElement psiElement;
                    PsiType psiType = psiMethod2.getReturnType();
                    String message4 = "The getter return type (`" + (psiType != null ? psiType.getPresentableText() : null) + "`) and setter parameter type (`" + setterParameterType.getPresentableText() + "`) getter and setter methods for property `" + propertyName + "` should have exactly the same type to allow " + "be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location = this.getPropertyLocation(psiMethod2, (PsiMethod)setter);
                    Object object = location.getSource();
                    if (!(object instanceof PsiElement)) {
                        object = null;
                    }
                    if ((psiElement = (PsiElement)object) == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location, (String)message4, null, (int)16, null);
                    return;
                }
                PsiMethod[] message3 = psiMethod2.findSuperMethods();
                int element$iv2 = message3.length;
                int location = 0;
                while (location < element$iv2) {
                    PsiMethod superMethod;
                    PsiMethod psiMethod3 = superMethod = message3[location];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod3, (String)"superMethod");
                    PsiClass psiClass = psiMethod3.getContainingClass();
                    if (psiClass == null || !psiClass.isInterface()) {
                        PsiType superReturnType;
                        if (superMethod.getReturnType() == null) return;
                        Intrinsics.checkExpressionValueIsNotNull((Object)superReturnType, (String)"superMethod.returnType ?: return");
                        PsiType getterType = psiMethod2.getReturnType();
                        if (Intrinsics.areEqual((Object)superReturnType, (Object)getterType) ^ true) {
                            PsiElement psiElement;
                            PsiType psiType = getterType;
                            String message5 = "The getter return type (`" + (psiType != null ? psiType.getPresentableText() : null) + "`)" + " is not the same as the setter return type " + "(`" + superReturnType.getPresentableText() + "`); they should have " + "exactly the same type to allow " + '`' + StringHelper.usLocaleDecapitalize((String)propertySuffix) + "` " + "be accessed as a property from Kotlin; see " + "https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                            Location location2 = this.getPropertyLocation(psiMethod2, (PsiMethod)setter);
                            Object object = location2.getSource();
                            if (!(object instanceof PsiElement)) {
                                object = null;
                            }
                            if ((psiElement = (PsiElement)object) == null) {
                                psiElement = (PsiElement)setter;
                            }
                            JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location2, (String)message5, null, (int)16, null);
                            return;
                        }
                    }
                    ++location;
                }
                return;
            }
            if (badGetter == null) return;
            if (badGetter == null) {
                Intrinsics.throwNpe();
            }
            Object[] objectArray = badGetter.findSuperMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"badGetter!!.findSuperMethods()");
            if (ArraysKt.any((Object[])objectArray)) return;
            JavaVisitor javaVisitor = this;
            char setterParameterType = '\u0000';
            char superMethod = '\u0000';
            JavaVisitor $this$run222 = javaVisitor;
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("set");
            if (badGetter == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)methodName, (Object)(matchingName = stringBuilder.append(StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)badGetter.getName(), (CharSequence)"is"), (CharSequence)"get"), (CharSequence)"has")).toString()))) {
                UMethod[] $this$none$iv = cls.getMethods();
                boolean $i$f$none = false;
                jvmParameterArray = $this$none$iv;
                n = jvmParameterArray.length;
                for (int i = 0; i < n; ++i) {
                    JvmParameter element$iv3;
                    JvmParameter it = element$iv3 = jvmParameterArray[i];
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)matchingName)) continue;
                    return;
                }
                boolean bl6 = true;
                if (!bl6) return;
            }
            boolean bl7 = true;
            if (!bl7) return;
            if (badGetter == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)(string = badGetter.getName()), (String)"is", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)methodName, (String)"setIs", (boolean)false, (int)2, null)) {
                setterParameterType = string.charAt(2);
                superMethod = '\u0000';
                if (Character.isUpperCase(setterParameterType)) {
                    superMethod = string.charAt(2);
                    boolean $this$run222 = false;
                    superMethod = Character.toLowerCase(superMethod);
                    String $this$run222 = string;
                    n3 = 3;
                    boolean bl8 = false;
                    String string5 = $this$run222;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    $this$run222 = string6;
                    n3 = 0;
                    String newProperty = String.valueOf(superMethod) + $this$run222;
                    String message6 = "This method should be called `set" + StringHelper.usLocaleCapitalize((String)newProperty) + "` such " + "that (along with the `" + string + "` getter) Kotlin code can access it " + "as a property (`" + newProperty + "`); see " + "https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location = this.context.getNameLocation(setter);
                    this.context.report(KOTLIN_PROPERTY, setter, location, message6);
                    return;
                }
            }
            if (badGetter == null) {
                Intrinsics.throwNpe();
            }
            Location location = this.context.getNameLocation((UMethod)badGetter);
            String message7 = "This method should be called `get" + propertySuffix + "` such that `" + propertyName + "` can " + "be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
            this.context.report(KOTLIN_PROPERTY, (UMethod)badGetter, location, message7);
        }

        private final boolean isTypeVariableReference(PsiType type) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"type.resolve() ?: return false");
                PsiClass cls = psiClass;
                return cls instanceof PsiTypeParameter;
            }
            return false;
        }

        private final boolean hasSetter(UClass cls, PsiType type, String setterName) {
            PsiMethod[] psiMethodArray = cls.findMethodsByName(setterName, true);
            int n = psiMethodArray.length;
            for (int i = 0; i < n; ++i) {
                PsiParameter[] parameters;
                PsiParameterList parameterList;
                PsiMethod method;
                PsiMethod psiMethod = method = psiMethodArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod.getParameterList(), (String)"method.parameterList");
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterList.getParameters(), (String)"parameterList.parameters");
                if (parameters.length != 1) continue;
                PsiParameter psiParameter = parameters[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[0]");
                if (!Intrinsics.areEqual((Object)psiParameter.getType(), (Object)type)) continue;
                return true;
            }
            return false;
        }

        private final Location getPropertyLocation(PsiMethod location1, PsiMethod location2) {
            PsiMethod primary = null;
            PsiMethod secondary = null;
            if (location1 instanceof PsiCompiledElement) {
                primary = location2;
                secondary = location1;
            } else {
                primary = location1;
                secondary = location2;
            }
            Location location = this.context.getNameLocation((PsiElement)primary);
            Location location3 = this.context.getNameLocation((PsiElement)secondary);
            StringBuilder stringBuilder = new StringBuilder();
            String string = secondary.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"secondary.name");
            return Location.withSecondary$default((Location)location, (Location)location3, (String)stringBuilder.append(StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null) ? "Setter" : "Getter").append(" here").toString(), (boolean)false, (int)4, null);
        }

        private final void ensureNullnessKnown(UDeclaration node, PsiType type) {
            Location location;
            Location location2;
            UDeclaration curr;
            if (type instanceof PsiPrimitiveType) {
                return;
            }
            if (node instanceof UField) {
                PsiModifierList psiModifierList = ((UField)node).getModifierList();
                if (psiModifierList != null) {
                    if (psiModifierList.hasModifierProperty("final")) {
                        return;
                    }
                }
            }
            UDeclaration uDeclaration = node;
            if (uDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UAnnotated");
            }
            for (UAnnotation annotation : this.context.getEvaluator().getAllAnnotations((UAnnotated)uDeclaration, false)) {
                String name;
                if (annotation.getQualifiedName() == null) {
                    continue;
                }
                if (Issues.isNullableAnnotation(name)) {
                    if (this.isToStringMethod(node)) {
                        Location location3 = this.context.getLocation((UElement)annotation);
                        String message2 = "Unexpected `@Nullable`: `toString` should never return null";
                        JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)location3, (String)message2, null, (int)16, null);
                    }
                    return;
                }
                if (!Issues.isNonNullAnnotation(name)) continue;
                if (this.isEqualsParameter(node)) {
                    Location location4 = this.context.getLocation((UElement)annotation);
                    String message3 = "Unexpected @NonNull: The `equals` contract allows the parameter to be null";
                    JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)location4, (String)message3, null, (int)16, null);
                }
                return;
            }
            if (this.isEqualsParameter(node) || this.isToStringMethod(node)) {
                return;
            }
            if (node instanceof UMethod) {
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                if (uClass != null) {
                    UAnnotation annotation;
                    annotation = uClass;
                    boolean bl = false;
                    boolean name = false;
                    UAnnotation it = annotation;
                    boolean bl2 = false;
                    if (it.isAnnotationType()) {
                        return;
                    }
                }
            }
            if (Issues.getIGNORE_DEPRECATED()) {
                UElement deprecatedNode;
                UElement uElement = deprecatedNode = node instanceof UParameter ? node.getUastParent() : (UElement)node;
                Object object = uElement != null ? uElement.getSourcePsi() : null;
                if (!(object instanceof PsiDocCommentOwner)) {
                    object = null;
                }
                PsiDocCommentOwner psiDocCommentOwner = (PsiDocCommentOwner)object;
                if (psiDocCommentOwner != null) {
                    if (psiDocCommentOwner.isDeprecated()) {
                        return;
                    }
                }
                curr = deprecatedNode;
                while (curr != null) {
                    UClass uClass = UastUtils.getContainingUClass((UElement)curr);
                    if (uClass == null) {
                        break;
                    }
                    curr = (UElement)uClass;
                    PsiElement psiElement = curr.getSourcePsi();
                    if (!(psiElement instanceof PsiDocCommentOwner)) {
                        psiElement = null;
                    }
                    PsiDocCommentOwner psiDocCommentOwner2 = (PsiDocCommentOwner)psiElement;
                    if (psiDocCommentOwner2 == null) continue;
                    if (!psiDocCommentOwner2.isDeprecated()) continue;
                    return;
                }
            }
            if ((curr = node) instanceof UVariable) {
                UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                if (uTypeReferenceExpression == null) {
                    return;
                }
                location2 = this.context.getLocation((UElement)uTypeReferenceExpression);
            } else if (curr instanceof UMethod) {
                PsiTypeElement psiTypeElement = ((UMethod)node).getReturnTypeElement();
                if (psiTypeElement == null) {
                    return;
                }
                location2 = this.context.getLocation((PsiElement)psiTypeElement);
            } else {
                return;
            }
            Location location5 = location2;
            if (node instanceof UParameter) {
                location = location5;
            } else if (node instanceof UMethod && ((UMethod)node).getModifierList() != null) {
                PsiModifierList psiModifierList = ((UMethod)node).getModifierList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"node.modifierList");
                location = this.context.getLocation((PsiElement)psiModifierList);
            } else if (node instanceof UField && ((UField)node).getModifierList() != null) {
                PsiModifierList psiModifierList = ((UField)node).getModifierList();
                if (psiModifierList == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"node.modifierList!!");
                location = this.context.getLocation((PsiElement)psiModifierList);
            } else {
                return;
            }
            Location replaceLocation = location;
            String message4 = "Unknown nullability; explicitly declare as `@Nullable` or `@NonNull` to improve Kotlin interoperability; see https://android.github.io/kotlin-guides/interop.html#nullability-annotations";
            LintFix fix = LintFix.create().alternatives(new LintFix[]{LintFix.create().replace().name("Annotate @NonNull").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNonNullAnnotation(this.context) + ' ').build(), LintFix.create().replace().name("Annotate @Nullable").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNullableAnnotation(this.context) + ' ').build()});
            this.context.report(PLATFORM_NULLNESS, (UElement)node, location5, message4, fix);
        }

        private final boolean isEqualsParameter(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return false;
                }
                UMethod method = uMethod;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"equals") && method.getUastParameters().size() == 1) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isToStringMethod(UDeclaration node) {
            UDeclaration method;
            return node instanceof UMethod && Intrinsics.areEqual((Object)((UMethod)(method = node)).getName(), (Object)"toString") && ((UMethod)method).getUastParameters().isEmpty();
        }

        private final String getNonNullAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nonNullAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private final String getNullableAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nullableAnnotation;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private final void initializeAnnotationNames(JavaContext context) {
            if (this.nonNullAnnotation == null) {
                Collection<AndroidLibrary> libraries = GradleDetector.Companion.getAndroidLibraries(context.getMainProject());
                for (AndroidLibrary library : libraries) {
                    MavenCoordinates coordinates;
                    MavenCoordinates mavenCoordinates = coordinates = library.getResolvedCoordinates();
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                    String string = mavenCoordinates.getGroupId();
                    if (!(string != null ? StringsKt.startsWith$default((String)string, (String)"androidx", (boolean)false, (int)2, null) : false)) continue;
                    this.nonNullAnnotation = "@androidx.annotation.NonNull";
                    this.nullableAnnotation = "@androidx.annotation.Nullable";
                    return;
                }
                this.nonNullAnnotation = "@android.support.annotation.NonNull";
                this.nullableAnnotation = "@android.support.annotation.Nullable";
            }
        }

        private final void ensureNonKeyword(String name, UDeclaration node, String typeLabel) {
            if (Issues.isKotlinHardKeyword(name)) {
                if (node instanceof UMethod && JavaEvaluator.isOverride$default((JavaEvaluator)this.context.getEvaluator(), (UMethod)((UMethod)node), (boolean)false, (int)2, null)) {
                    return;
                }
                String message2 = "Avoid " + typeLabel + " names that are Kotlin hard keywords (\"" + name + "\"); see " + "https://android.github.io/kotlin-guides/interop.html#no-hard-keywords";
                UDeclaration uDeclaration = node;
                if (uDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UElement");
                }
                JavaContext.report$default((JavaContext)this.context, (Issue)NO_HARD_KOTLIN_KEYWORDS, (UElement)((UElement)uDeclaration), (Location)this.context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void ensureLambdaLastParameter(UMethod method) {
            int lastIndex;
            List parameters = method.getUastParameters();
            if (parameters.size() > 1 && !this.isFunctionalInterface(((UParameter)parameters.get(lastIndex = parameters.size() - 1)).getType())) {
                int n = lastIndex - 1;
                boolean bl = false;
                while (n >= 0) {
                    void i;
                    UParameter parameter = (UParameter)parameters.get((int)i);
                    if (this.isFunctionalInterface(parameter.getType()) && !Intrinsics.areEqual((Object)parameter.getType().getCanonicalText(), (Object)"java.util.concurrent.Executor")) {
                        PsiClass psiClass = method.getContainingClass();
                        String message2 = "Functional interface parameters (such as parameter " + (int)(i + true) + ", \"" + parameter.getName() + "\", in " + (psiClass != null ? psiClass.getQualifiedName() : null) + '.' + method.getName() + ") should be last to improve Kotlin interoperability; see " + "https://kotlinlang.org/docs/reference/java-interop.html#sam-conversions";
                        Object e = parameters.get(lastIndex);
                        if (e == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UElement");
                        }
                        this.context.report(LAMBDA_LAST, method, this.context.getLocation((UElement)e), message2);
                        break;
                    }
                    --i;
                }
            }
        }

        private final boolean isFunctionalInterface(PsiType type) {
            PsiMethod method;
            int n;
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"type.resolve() ?: return false");
            PsiClass cls = psiClass;
            if (!cls.isInterface()) {
                return false;
            }
            int abstractCount = 0;
            PsiMethod[] psiMethodArray = cls.getMethods();
            int n2 = psiMethodArray.length;
            for (n = 0; n < n2; ++n) {
                PsiMethod psiMethod = method = psiMethodArray[n];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
                if (!psiMethod.getModifierList().hasModifierProperty("abstract")) continue;
                ++abstractCount;
            }
            if (abstractCount != 1) {
                if (abstractCount > 1) {
                    abstractCount = 0;
                    psiMethodArray = cls.getMethods();
                    n2 = psiMethodArray.length;
                    for (n = 0; n < n2; ++n) {
                        PsiMethod psiMethod = method = psiMethodArray[n];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
                        if (!psiMethod.getModifierList().hasModifierProperty("abstract") || this.context.getEvaluator().isOverride(method, true)) continue;
                        ++abstractCount;
                    }
                }
                if (abstractCount != 1) {
                    return false;
                }
            }
            PsiClass psiClass2 = cls.getSuperClass();
            if (psiClass2 != null) {
                if (psiClass2.isInterface()) {
                    return false;
                }
            }
            return true;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public JavaVisitor(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.checkForKeywords = this.context.isEnabled(NO_HARD_KOTLIN_KEYWORDS);
            this.checkNullness = this.context.isEnabled(PLATFORM_NULLNESS);
            this.checkLambdaLast = this.context.isEnabled(LAMBDA_LAST);
            this.checkPropertyAccess = this.context.isEnabled(KOTLIN_PROPERTY);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$Issues;", "", "()V", "IGNORE_DEPRECATED", "", "getIGNORE_DEPRECATED", "()Z", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KOTLIN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "LAMBDA_LAST", "NO_HARD_KOTLIN_KEYWORDS", "PLATFORM_NULLNESS", "isApi", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "isKotlinHardKeyword", "keyword", "", "isNonNullAnnotation", "qualifiedName", "isNullableAnnotation", "studio.android.sdktools.lint-checks"})
    public static final class Issues {
        public final boolean getIGNORE_DEPRECATED() {
            return IGNORE_DEPRECATED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isKotlinHardKeyword(String keyword) {
            String string = keyword;
            switch (string.hashCode()) {
                case 101577: {
                    if (!string.equals("for")) return false;
                    return true;
                }
                case 3211: {
                    if (!string.equals("do")) return false;
                    return true;
                }
                case 502623545: {
                    if (!string.equals("interface")) return false;
                    return true;
                }
                case 113101617: {
                    if (!string.equals("while")) return false;
                    return true;
                }
                case 3648314: {
                    if (!string.equals("when")) return false;
                    return true;
                }
                case -567202649: {
                    if (!string.equals("continue")) return false;
                    return true;
                }
                case 3116345: {
                    if (!string.equals("else")) return false;
                    return true;
                }
                case 520977238: {
                    if (!string.equals("typealias")) return false;
                    return true;
                }
                case 94742904: {
                    if (!string.equals("class")) return false;
                    return true;
                }
                case 3357: {
                    if (!string.equals("if")) return false;
                    return true;
                }
                case -858802543: {
                    if (!string.equals("typeof")) return false;
                    return true;
                }
                case 116513: {
                    if (!string.equals("val")) return false;
                    return true;
                }
                case -807062458: {
                    if (!string.equals("package")) return false;
                    return true;
                }
                case 94001407: {
                    if (!string.equals("break")) return false;
                    return true;
                }
                case 3365: {
                    if (!string.equals("in")) return false;
                    return true;
                }
                case 116519: {
                    if (!string.equals("var")) return false;
                    return true;
                }
                case 97196323: {
                    if (!string.equals("false")) return false;
                    return true;
                }
                case 3559070: {
                    if (!string.equals("this")) return false;
                    return true;
                }
                case 3370: {
                    if (!string.equals("is")) return false;
                    return true;
                }
                case 109801339: {
                    if (!string.equals("super")) return false;
                    return true;
                }
                case 3122: {
                    if (!string.equals("as")) return false;
                    return true;
                }
                case 3392903: {
                    if (!string.equals("null")) return false;
                    return true;
                }
                case 110339814: {
                    if (!string.equals("throw")) return false;
                    return true;
                }
                case 3569038: {
                    if (!string.equals("true")) return false;
                    return true;
                }
                case 115131: {
                    if (!string.equals("try")) return false;
                    return true;
                }
                case 101759: {
                    if (!string.equals("fun")) return false;
                    return true;
                }
                case -934396624: {
                    if (!string.equals("return")) return false;
                    return true;
                }
                case -1023368385: {
                    if (!string.equals("object")) return false;
                    return true;
                }
            }
            return false;
        }

        private final boolean isNullableAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"Nullable", (boolean)false, (int)2, null);
        }

        private final boolean isNonNullAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"NonNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"NotNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"Nonnull", (boolean)false, (int)2, null);
        }

        private final boolean isApi(JavaContext context, UDeclaration declaration) {
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.isPublic((PsiModifierListOwner)declaration) || evaluator.isProtected((PsiModifierListOwner)declaration)) {
                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)declaration), UClass.class, (boolean)false, (int)2, null);
                if (uClass == null) {
                    return true;
                }
                UClass cls = uClass;
                return evaluator.isPublic((PsiModifierListOwner)cls) && !(cls instanceof UAnonymousClass);
            }
            return false;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

