/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.profiles;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.IncorrectOperationException;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @since 14.1
 */
public class SpringProfile extends RenameableFakePsiElement {

  private String myProfileName;

  public SpringProfile(@NotNull final String profileName,
                       final PsiElement definition) {
    super(definition);
    myProfileName = profileName;
  }

  @NotNull
  @Override
  public PsiElement getNavigationElement() {
    return getParent(); // definition element
  }

  @NotNull
  public String getName() {
    return myProfileName;
  }

  public String getTypeName() {
    return SpringApiBundle.message("profile.type.name");
  }

  @Override
  public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
    final PsiElement res = super.setName(name);
    myProfileName = name;
    return res;
  }

  public Icon getIcon() {
    return SpringApiIcons.SpringProfile;
  }
}