/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.Namespace;
import com.intellij.spring.constants.SpringConstants;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * http://www.springframework.org/schema/beans:propsType interface.
 */
@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
public interface Props extends DomElement, BaseCollection {

	/**
	 * Returns the list of prop children.
	 * <pre>
	 * <h3>Element http://www.springframework.org/schema/beans:prop documentation</h3>
	 * 	The string value of the property. Note that whitespace is trimmed
	 * 	off to avoid unwanted whitespace caused by typical XML formatting.
	 * 			
	 * </pre>
	 * @return the list of prop children.
	 */
	@NotNull
	List<Prop> getProps();
	/**
	 * Adds new child to the list of prop children.
	 * @return created child
	 */
	Prop addProp();
}
