/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.LookupMethodBeanConverter;
import com.intellij.spring.model.converters.SpringBeanLookupMethodConverter;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;

/**
 * http://www.springframework.org/schema/beans:lookup-methodElemType interface.
 */
public interface LookupMethod extends DomElement {

	/**
	 * Returns the value of the name child.
	 * <pre>
	 * <h3>Attribute null:name documentation</h3>
	 * 	The name of the lookup method. This method must take no arguments.
	 * 							
	 * </pre>
	 * @return the value of the name child.
	 */
	@NotNull
        @Convert(value = SpringBeanLookupMethodConverter.class)  
        @Stubbed
        GenericAttributeValue<PsiMethod> getName();


	/**
	 * Returns the value of the bean child.
	 * <pre>
	 * <h3>Attribute null:bean documentation</h3>
	 * 	The name of the bean in the current or ancestor factories that
	 * 	the lookup method should resolve to. Often this bean will be a
	 * 	prototype, in which case the lookup method will return a distinct
	 * 	instance on every invocation. This is useful for single-threaded objects.
	 * 							
	 * </pre>
	 * @return the value of the bean child.
	 */
	@NotNull
        @Convert(value = LookupMethodBeanConverter.class)  
        GenericAttributeValue<SpringBeanPointer> getBean();
}
