/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public abstract class SpringBeanUtils {

  public static SpringBeanUtils getInstance() {
    return ServiceManager.getService(SpringBeanUtils.class);
  }

  public abstract CommonSpringBean findBean(@Nullable PomTarget target) ;

  public abstract CommonSpringBean findBean(@Nullable final PsiElement identifyingPsiElement);

  @Nullable
  public abstract SpringBeanPointer findBean(@NotNull final CommonSpringModel model, @NonNls @NotNull String beanName);

  @NotNull
  public abstract Set<String> findBeanNames(@NotNull final CommonSpringBean bean);

  public abstract boolean processChildBeans(@NotNull DomElement parent,
                                            final boolean includeParsedCustomBeanWrappers,
                                            @NotNull Processor<CommonSpringBean> processor);
}
