/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.scope;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @since 14
 */
public abstract class SpringBeanScopeManager {

  public static SpringBeanScopeManager getInstance() {
    return ServiceManager.getService(SpringBeanScopeManager.class);
  }

  /**
   * Returns all <em>custom</em> bean scopes applicable in the current context.
   *
   * @param element Context.
   * @return Custom bean scopes.
   * @see SpringCustomBeanScope
   */
  public abstract List<SpringBeanScope> getCustomBeanScopes(@Nullable PsiElement element);
}
