/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.pom;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Yann C&eacute;bron
 */
public class SpringBeanPomTargetUtils {

  private SpringBeanPomTargetUtils() {
  }

  @Nullable
  public static CommonSpringBean getSpringBean(PsiElement element) {
    if (!(element instanceof PomTargetPsiElement)) {
      return null;
    }

    PomTargetPsiElement pomTargetPsiElement = (PomTargetPsiElement)element;
    final PomTarget target = pomTargetPsiElement.getTarget();
    if (!target.isValid()) {
      return null;
    }

    return getSpringBean(target);
  }

  @Nullable
  public static CommonSpringBean getSpringBean(@NotNull PomTarget target) {
    if (target instanceof AliasingPsiTarget) {
      final PsiElement navigationElement = ((AliasingPsiTarget)target).getNavigationElement();
      if (!(navigationElement instanceof PsiClass)) return null;

      final SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement((PsiClass)navigationElement);
      if (stereotypeElement != null &&
          stereotypeElement.getPsiTarget() instanceof AliasingPsiTarget) {
        return stereotypeElement;
      }

      return null;
    }

    if (target instanceof SpringBeanPsiTarget) {
      return ((SpringBeanPsiTarget)target).getSpringBean();
    }

    if (target instanceof JamPomTarget) {
      final JamElement jamElement = ((JamPomTarget)target).getJamElement();
      if (jamElement instanceof JamPsiMemberSpringBean) {
        return ((JamPsiMemberSpringBean)jamElement);
      }
    }

    return null;
  }
}
