/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.testContexts.profiles;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

/**
 * @since 2017.2
 */
public interface SpringActiveProfile extends JamElement {
  String VALUE_ATTR_NAME = "value";
  String PROFILES_ATTR_NAME = "profiles";
  String[] PROFILES_ATTRS = {PROFILES_ATTR_NAME, VALUE_ATTR_NAME};

  SemKey<JamAnnotationMeta> ACTIVE_PROFILE_JAM_ANNOTATION_KEY = JamService.ANNO_META_KEY.subKey("SpringActiveProfile");
  SemKey<SpringActiveProfile> ACTIVE_PROFILE_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringActiveProfile");
  SemKey<JamMemberMeta> ACTIVE_PROFILE_META_KEY = JamService.getMetaKey(ACTIVE_PROFILE_JAM_KEY);

  @Nullable
  PsiMember getPsiElement();

  @Nullable
  PsiAnnotation getAnnotation();
  @Nullable
  PsiElement getIdentifyingPsiElement();

  @NotNull
  Set<String> getActiveProfiles();
}
