/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.actions.patterns.frameworks.ui;

import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.module.Module;
import com.intellij.spring.model.actions.patterns.frameworks.util.StandardBeansDocLinksManager;

public class TemplateInfo {
  private final Template myTemplate;
  private final String myName;
  private final String myReferenceLink;
  private final String myApiLink;
  private final String myDescription;
  private boolean myAccepted;

  public TemplateInfo(final Module module, final Template template, String name, String description) {
     this(module,  template, name, description, true);
  }

  public TemplateInfo(final Module module, final Template template, String name, String description, boolean isAccepted) {
    myTemplate = template;
    myName = name;
    final StandardBeansDocLinksManager linksManager = StandardBeansDocLinksManager.getInstance();
    myReferenceLink = linksManager.getReferenceLink(template.getId());
    myApiLink = linksManager.getApiLink(template.getId());
    myDescription = description;
    myAccepted = isAccepted;
  }

  public Template getTemplate() {
    return myTemplate;
  }

  public boolean isAccepted() {
    return myAccepted;
  }

  public void setAccepted(final boolean accepted) {
    myAccepted = accepted;
  }

  public String getName() {
    return myName;
  }

  public String getDescription() {
    return myDescription == null ? "" : myDescription;
  }

  public String getReferenceLink() {
    return myReferenceLink;
  }

  public String getApiLink() {
    return myApiLink;
  }

}
