/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.facet.*;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public abstract class AbstractFrameworkIntegrationAction extends FrameworkIntegrationAction {

  protected void generateSpringBeans(final Module module, final Editor editor, final XmlFile xmlFile) {
    FrameworkSupportTemplatesRunner.getInstance().generateSpringBeans(this, module, editor, xmlFile);
  }

  @NotNull
  public Map<String, String> getPredefinedVars(@NotNull Module module, XmlFile xmlFile) {
    return FrameworkSupportTemplatesRunner.getInstance().getPredefinedVars(module, xmlFile);
  }

  public void addFacet(final Module module) {
    if (module == null) return;

    final String facetId = getFacetId();
    if (!StringUtil.isEmptyOrSpaces(facetId)) {

      final FacetManager facetManager = FacetManager.getInstance(module);
      final FacetType<?, ?> type = FacetTypeRegistry.getInstance().findFacetType(facetId);

      if (type != null) {

        if (facetManager.getFacetByType(type.getId()) == null) {
          final ModifiableFacetModel model = facetManager.createModifiableModel();

          final Facet facet = facetManager.addFacet(type, type.getDefaultFacetName(), null);

          model.addFacet(facet);
          model.commit();
        }
      }
    }
  }

  @Nullable
  protected String getFacetId() {
    return null;
  }
}
