/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

public class GenerateSpringDomElementAction extends GenerateDomElementAction {

  public GenerateSpringDomElementAction(final GenerateDomElementProvider provider) {
    super(provider);
  }

  public GenerateSpringDomElementAction(final GenerateDomElementProvider provider, Icon icon) {
    super(provider);
    getTemplatePresentation().setIcon(icon);
  }

  public boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
    return super.isValidForFile(project, editor, file) &&
           file instanceof XmlFile &&
           SpringDomUtils.isSpringXml((XmlFile)file) &&
           SpringManager.getInstance(project).getSpringModelByFile(file) != null;
  }
}