/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.database.util;

import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.sql.Connection;

/**
 * JDBC operation to be used with DataSource#performJdbcOperation.
 * @see DataSource#performJdbcOperation
 */
public interface JdbcOperation<T> {
  /**
   * Performs the operation.
   * @param connection JDBC connection
   * @param indicator  current progress indicator
   * @return the object that will be returned by performOperation
   * @throws Exception
   */
  @Nullable
  T perform(@NotNull final Connection connection, @NotNull ProgressIndicator indicator) throws Exception;
}
