/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.model;

import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Represents a database model.
 * <p/>
 * This model contains database meta-data,
 * but it doesn't contain connections or methods to access this database. Just meta-data.
 */
public interface DasModel extends CasingProvider {

  @NotNull
  JBIterable<? extends DasObject> getModelRoots();

  @Nullable
  DasNamespace getCurrentRootNamespace();

  @NotNull
  JBTreeTraverser<DasObject> traverser();

  /**
   * @deprecated todo will be replaced by more generic APIs
   */
  @NotNull @Deprecated
  JBIterable<? extends DasConstraint> getExportedKeys(DasTable table);

}
