package com.intellij.psi.css.impl.util.table;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Eugene.Kudelevsky
 */
public interface CssTableValue<V extends CssTableValue, T> {

  String DEFAULT_VALUES_DELIMITER = " ";

  V addChild(@NotNull V child);

  T getValue();

  @NotNull
  Type getType();

  void setType(@NotNull Type type);

  String getPrefix();

  void setPrefix(String prefix);

  void setHasImmutablePrefix(boolean hasImmutablePrefix);

  boolean hasImmutablePrefix();

  String getValuesDelimiter();

  void setValuesDelimiter(String valuesDelimiter);

  boolean isGroup();

  int getMinCount();

  void setMinCount(int minCount);

  int getMaxCount();

  void setMaxCount(int maxCount);

  List<V> getChildren();

  void accept(@NotNull CssTableValueVisitor visitor);

  enum Type {
    OR,
    ANY,
    FULL_ANY,
    DEFAULT
  }
}
