package com.intellij.psi.css.descriptor.value;

import com.intellij.psi.css.descriptor.CssElementDescriptor;
import org.jetbrains.annotations.Nullable;

/**
 * User: zolotov
 * Date: 7/2/13
 * <p/>
 * Represents descriptor of css value (it could be css-function parameter of css-property value)
 */
public interface CssValueDescriptor extends CssElementDescriptor {

  <T extends CssValueDescriptorVisitor> void accept(T visitor);
  
  /**
   * @return parent descriptor or {@code null} if it is root value descriptor
   */
  @Nullable
  CssValueDescriptor getParent();

  /**
   * @return minimum possible occurrences count of value
   */
  int getMinOccur();

  /**
   * @return maximum possible occurrences count of value
   */
  int getMaxOccur();

  /**
   * @return version of css specification where value initially marked as obsoleted or {@code null} if value still actual
   */
  @Nullable
  CssVersion getObsoleteVersion();

  /**
   * @return return comment that describes the reason of value obsoleted status or {@code null} if value is not obsolete
   */
  @Nullable
  String getObsoleteTooltip();

  /**
   * Value descriptor that can't be used in this descriptor.
   * E.g. css property "specific-voice" can accept any voice name (css identifier) except generic-voices (male, female, child),
   * so descriptor of "specific-voice" property value is {@link CssAnyValue} with exclusion value that described list of generic-voices.
   *
   * @return value descriptor
   */
  @Nullable
  CssValueDescriptor getExclusion();

  /**
   * @return false if value must not appear in completion list
   */
  boolean isShowInCompletion();

  /**
   * represents mult-comma value modifier (see for details: http://dev.w3.org/csswg/css-values-3/#mult-comma)
   */
  boolean isCommaSeparated();
}
