package com.intellij.psi.css;

import gnu.trove.THashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * @author Eugene.Kudelevsky
 */
public class CssPropertyInfo {
  public static final CssPropertyInfo[] EMPTY_ARRAY = new CssPropertyInfo[0];

  @NonNls public static final String INITIAL_VALUE_ATTRIBUTE = "initialValue";
  @NonNls public static final String APPLIES_TO_ATTRIBUTE = "appliesTo";
  @NonNls public static final String INHERITED_ATTRIBUTE = "inherited";
  @NonNls public static final String PERCENTAGE_ATTRIBUTE = "percentage";
  @NonNls public static final String MEDIA_GROUP_ATTRIBUTE = "mediaGroup";
  @NonNls public static final String HELP_REF_ATTRIBUTE = "helpRef";

  private final Map<String, String> myAttributeMap = new THashMap<>();
  private final CssPropertyDescriptor.CssVersion myVersion;

  public CssPropertyInfo(@NotNull Element e, @NotNull CssPropertyDescriptor.CssVersion version) {
    addAttributes(e, INITIAL_VALUE_ATTRIBUTE, APPLIES_TO_ATTRIBUTE, INHERITED_ATTRIBUTE, PERCENTAGE_ATTRIBUTE, MEDIA_GROUP_ATTRIBUTE,
                  HELP_REF_ATTRIBUTE);
    myVersion = version;
  }

  private void addAttributes(@NotNull Element element, @NotNull String... names) {
    for (String name : names) {
      final String attributeValue = element.getAttributeValue(name);
      if (attributeValue != null) {
        myAttributeMap.put(name, attributeValue);
      }
    }
  }

  @Nullable
  public String getAttributeValue(@NotNull String attributeName) {
    return myAttributeMap.get(attributeName);
  }

  public String getInherited() {
    return myAttributeMap.get(INHERITED_ATTRIBUTE);
  }

  public String getHelpRef() {
    return myAttributeMap.get(HELP_REF_ATTRIBUTE);
  }

  @NotNull
  public CssPropertyDescriptor.CssVersion getVersion() {
    return myVersion;
  }
}
