package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public interface CssMediaFeature extends CssElement, PsiNamedElement, CssDescriptorOwner, CssValueOwner {
  @NotNull
  String getName();

  @Nullable
  PsiElement getNameIdentifier();
  
  @NotNull
  Collection<? extends CssMediaFeatureDescriptor> getDescriptors();
  
  @NotNull
  Collection<? extends CssMediaFeatureDescriptor> getDescriptors(@NotNull PsiElement context);
}
