package com.intellij.lang.css;

import com.intellij.css.util.CssConstants;
import com.intellij.lang.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSSLanguage extends Language implements CssLanguageProperties {
  public final static CSSLanguage INSTANCE = new CSSLanguage();

  protected CSSLanguage() {
    super("CSS", "text/css");
  }

  public CSSLanguage(@NotNull @NonNls String ID, @NotNull @NonNls String... mimeTypes) {
    super(ID, mimeTypes);
  }

  protected CSSLanguage(@Nullable Language baseLanguage, @NotNull @NonNls String ID, @NotNull @NonNls String... mimeTypes) {
    super(baseLanguage, ID, mimeTypes);
  }

  @NotNull
  @Override
  public String getDeclarationsTerminator() {
    return CssConstants.SEMICOLON;
  }

  @Override
  public boolean isIndentBased() {
    return false;
  }
}
