package com.intellij.javaee.web.validation;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.jsp.BaseJspFile;

/**
 * This is temporary solution to fix problem with JSP validation classes which are located in JavaEE plugin but depends on JSP plugin classes.
 * This class will be removed when we move JSP validation related classes to JSP plugin.
 *
 * @author nik
 */
public class WebJspFileIndexFacade {
  public static WebJspFileIndexFacade getInstance(Project project) {
    return ServiceManager.getService(project, WebJspFileIndexFacade.class);
  }

  public BaseJspFile[] getIncludedFiles(BaseJspFile file) {
    return BaseJspFile.EMPTY_ARRAY;
  }

  public boolean isIncluded(VirtualFile file) {
    return false;
  }
}
