/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ElementPresentationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
*/
public class ExistingElementWrapper<T extends JavaeeDomModelElement> implements DialogElementWrapper<T> {
  private final T myExistingElement;
  private final T myCopy;

  public ExistingElementWrapper(T existingElement, @Nullable final JavaeeFacet facet) {
    myExistingElement = existingElement;
    myCopy = new WriteCommandAction<T>(existingElement.getManager().getProject()) {
      protected void run(@NotNull Result<T> result) throws Throwable {
        final T t = (T)getExistingElement().createMockCopy(false);
        JavaeeFacetUtil.getInstance().setFacetForMockElement(t, facet);
        result.setResult(t);
      }
    }.execute().getResultObject();
  }

  public final T getElement() {
    return myCopy;
  }

  protected T getExistingElement() {
    return myExistingElement;
  }

  public T save() {
    final T t = getExistingElement();
    t.copyFrom(myCopy);
    return t;
  }

  public String getDialogTitle() {
    return J2EEBundle.message("dialog.title.edit.0", StringUtil.capitalizeWords(ElementPresentationManager.getTypeNameForObject(getElement()), true));
  }
}
