/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.module.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.actionSystem.*;
import com.intellij.openapi.project.Project;

import javax.swing.text.JTextComponent;

public class JavaeeViewDeleteAction extends AnAction {
  private final DataProvider myDataProvider;

  public JavaeeViewDeleteAction(DataProvider dataProvider) {
    super(J2EEBundle.message("action.name.remove"), null, AllIcons.General.Remove);
    myDataProvider = dataProvider;
  }

  public void update(AnActionEvent event) {
    DataProvider dataProvider = getDataProvider(event);
    final Project project = (Project) dataProvider.getData(DataConstants.PROJECT);
    final DeleteProvider provider;
    final boolean active;
    if (project == null) {
      active = false;
    }
    else {
      Object component = event.getDataContext().getData(DataConstants.CONTEXT_COMPONENT);
      provider = (DeleteProvider) dataProvider.getData(DataConstants.DELETE_ELEMENT_PROVIDER);
      active = !(component instanceof JTextComponent) &&
               provider != null && provider.canDeleteElement(event.getDataContext());
    }
    JavaeeAbstractAction.setActive(event, active);
  }

  private DataProvider getDataProvider(AnActionEvent event) {
    if (myDataProvider != null) return myDataProvider;
    final DataContext dataContext = event.getDataContext();
    return new DataProvider() {
      public Object getData(String dataId) {
        return dataContext.getData(dataId);
      }
    };
  }

  public void actionPerformed(AnActionEvent e) {
    DataProvider dataProvider = getDataProvider(e);
    DeleteProvider provider = (DeleteProvider) dataProvider.getData(DataConstants.DELETE_ELEMENT_PROVIDER);
    if (provider == null) return;
    provider.deleteElement(e.getDataContext());
  }
}
