package com.intellij.javaee.managedbean;

import com.intellij.javaee.model.common.managedbean.ManagedBean;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author Gregory.Shrago
 */
public abstract class ManagedBeanService {
  public static ManagedBeanService getInstance(final Project project) {
    return ServiceManager.getService(project, ManagedBeanService.class);
  }

  public abstract List<? extends ManagedBean> getManagedBeans(GlobalSearchScope scope);

  @Nullable
  public abstract ManagedBean getManagedBean(PsiClass psiClass);
}
