/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.descriptors.ConfigFileContainer;
import org.jetbrains.annotations.NotNull;

/**
 * @author nik
 */
public abstract class JavaeeFacet extends Facet<FacetConfiguration> implements FacetRootsProvider {

  protected JavaeeFacet(@NotNull final FacetType facetType, @NotNull final Module module, final String name,
                        @NotNull final FacetConfiguration configuration, final Facet underlyingFacet) {
    super(facetType, module, name, configuration, underlyingFacet);
  }

  public abstract ConfigFileContainer getDescriptorsContainer();

  public abstract ModificationTracker getModificationTracker();

  public abstract void addFacetListener(JavaeeFacetListener listener);
  public abstract void removeFacetListener(JavaeeFacetListener listener);

}
