/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ejb;

import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

/**
 * @author peter
 */
public abstract class EjbHelper {

  public static EjbHelper getEjbHelper() {
    return ServiceManager.getService(com.intellij.javaee.ejb.EjbHelper.class);
  }

  public abstract ActionGroup createAddEjbActionGroup(EjbFacet ejbFacet);

  public abstract EjbMethodRole getEjbRole(final PsiMethod method);

  public abstract EjbClassRole getEjbRole(final PsiClass psiClass);

  @NotNull
  public abstract EjbMethodRole[] getEjbRoles(final PsiMethod method);

  @NotNull
  public abstract EjbClassRole[] getEjbRoles(final PsiClass psiClass);

  @NotNull
  public abstract EjbClassRole[] getAllEjbRoles(final Project project);
}
