/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;

public final class DescriptorUtil {
    private DescriptorUtil() {
    }

    public static void processComponents(XmlTag root, ComponentType.Processor processor) {
        ComponentType[] types;
        for (ComponentType type : types = ComponentType.values()) {
            type.process(root, processor);
        }
    }

    public static void processActions(XmlTag root, ActionType.Processor processor) {
        ActionType[] types;
        for (ActionType type : types = ActionType.values()) {
            type.process(root, processor);
        }
    }

    public static void patchPluginXml(Patcher patcher, PsiClass klass, XmlFile pluginXml) throws IncorrectOperationException {
        DescriptorUtil.checkPluginXmlsWritable(klass.getProject(), pluginXml);
        WriteAction.run(() -> patcher.patchPluginXml(pluginXml, klass));
    }

    public static void checkPluginXmlsWritable(Project project, XmlFile pluginXml) {
        VirtualFile file = pluginXml.getVirtualFile();
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{file});
        if (status.hasReadonlyFiles()) {
            throw new IncorrectOperationException(DevKitBundle.message("error.plugin.xml.readonly", status.getReadonlyFiles()[0]));
        }
    }

    @Nullable
    public static String getPluginId(Module plugin) {
        assert (PluginModuleType.isOfType(plugin));
        XmlFile pluginXml = PluginModuleType.getPluginXml(plugin);
        if (pluginXml == null) {
            return null;
        }
        DomFileElement<IdeaPlugin> ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (ideaPlugin == null) {
            return null;
        }
        return ((IdeaPlugin)ideaPlugin.getRootElement()).getPluginId();
    }

    public static boolean isPluginXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return DescriptorUtil.getIdeaPlugin((XmlFile)file) != null;
    }

    @Nullable
    public static DomFileElement<IdeaPlugin> getIdeaPlugin(@NotNull XmlFile file) {
        if (file == null) {
            DescriptorUtil.$$$reportNull$$$0(0);
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, IdeaPlugin.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/util/DescriptorUtil", "getIdeaPlugin"));
    }

    public static interface Patcher {
        public void patchPluginXml(XmlFile var1, PsiClass var2) throws IncorrectOperationException;
    }
}

