/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.run.PluginConfigurationType;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class PluginModuleBuilder
extends JavaModuleBuilder {
    public ModuleType getModuleType() {
        return PluginModuleType.getInstance();
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        String contentEntryPath = this.getContentEntryPath();
        if (contentEntryPath == null) {
            return;
        }
        String resourceRootPath = contentEntryPath + "/resources";
        VirtualFile contentRoot = LocalFileSystem.getInstance().findFileByPath(contentEntryPath);
        if (contentRoot == null) {
            return;
        }
        ContentEntry contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)rootModel, (VirtualFile)contentRoot);
        if (contentEntry != null) {
            contentEntry.addSourceFolder(VfsUtilCore.pathToUrl((String)resourceRootPath), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        }
        String defaultPluginXMLLocation = resourceRootPath + "/META-INF/plugin.xml";
        Module module = rootModel.getModule();
        Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            VirtualFile file;
            PluginBuildConfiguration buildConfiguration = PluginBuildConfiguration.getInstance(module);
            if (buildConfiguration != null) {
                buildConfiguration.setPluginXmlPathAndCreateDescriptorIfDoesntExist(defaultPluginXMLLocation);
            }
            if ((file = LocalFileSystem.getInstance().findFileByPath(defaultPluginXMLLocation)) != null) {
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        Module module;
        if (project == null) {
            PluginModuleBuilder.$$$reportNull$$$0(0);
        }
        if ((module = super.commitModule(project, model)) != null) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings configuration = runManager.createRunConfiguration(DevKitBundle.message("run.configuration.title", new Object[0]), new PluginConfigurationType().getConfigurationFactories()[0]);
            runManager.addConfiguration(configuration, false);
            runManager.setSelectedConfiguration(configuration);
        }
        return module;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == IdeaJdk.getInstance();
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 0;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            PluginModuleBuilder.$$$reportNull$$$0(1);
        }
        return StdModuleTypes.JAVA.modifyProjectTypeStep(settingsStep, (ModuleBuilder)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/module/PluginModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "commitModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyProjectTypeStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

