/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.IncludedXmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class PluginDescriptorChooser {
    private static final Map<String, String> INTELLIJ_MODULES = ContainerUtil.immutableMapBuilder().put((Object)"platform-api", (Object)"PlatformExtensions.xml").put((Object)"platform-impl", (Object)"PlatformExtensions.xml").put((Object)"lang-api", (Object)"LangExtensions.xml").put((Object)"lang-impl", (Object)"LangExtensions.xml").put((Object)"vcs-api", (Object)"VcsExtensions.xml").put((Object)"vcs-impl", (Object)"VcsExtensions.xml").put((Object)"openapi", (Object)"IdeaPlugin.xml").put((Object)"java-impl", (Object)"IdeaPlugin.xml").put((Object)"java-analysis-impl", (Object)"IdeaPlugin.xml").build();

    public static void show(Project project, Editor editor, PsiFile file, final Consumer<DomFileElement<IdeaPlugin>> consumer) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        List<DomFileElement<IdeaPlugin>> elements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, module.getModuleWithDependentsScope());
        elements = ContainerUtil.filter((Collection)elements, element -> {
            VirtualFile virtualFile = element.getFile().getVirtualFile();
            return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
        });
        elements = PluginDescriptorChooser.findAppropriateIntelliJModule(module.getName(), elements);
        if (elements.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find plugin descriptor");
            return;
        }
        if (elements.size() == 1) {
            consumer.consume(elements.get(0));
            return;
        }
        BaseListPopupStep<PluginDescriptorCandidate> popupStep = new BaseListPopupStep<PluginDescriptorCandidate>("Choose Plugin Descriptor", PluginDescriptorChooser.createCandidates(module, elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(PluginDescriptorCandidate candidate) {
                return candidate.getIcon();
            }

            @NotNull
            public String getTextFor(PluginDescriptorCandidate candidate) {
                String string = candidate.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PluginDescriptorCandidate candidate) {
                String separatorText = candidate.getSeparatorText();
                if (separatorText != null) {
                    return new ListSeparator(separatorText);
                }
                return null;
            }

            public PopupStep onChosen(PluginDescriptorCandidate selectedValue, boolean finalChoice) {
                consumer.consume((Object)selectedValue.myDomFileElement);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser$1", "getTextFor"));
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
    }

    @NotNull
    public static Extensions findOrCreateExtensionsForEP(DomFileElement<IdeaPlugin> domFileElement, String epName) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)domFileElement.getRootElement();
        List<Extensions> extensionsList = ideaPlugin.getExtensions();
        for (Extensions extensions : extensionsList) {
            String s;
            if (extensions.getXmlTag() instanceof IncludedXmlTag || (s = extensions.getDefaultExtensionNs().getStringValue()) == null || !epName.startsWith(s)) continue;
            Extensions extensions2 = extensions;
            if (extensions2 == null) {
                PluginDescriptorChooser.$$$reportNull$$$0(0);
            }
            return extensions2;
        }
        Extensions extensions = ideaPlugin.addExtensions();
        String epPrefix = StringUtil.getPackageName((String)epName);
        extensions.getDefaultExtensionNs().setStringValue(epPrefix);
        Extensions extensions3 = extensions;
        if (extensions3 == null) {
            PluginDescriptorChooser.$$$reportNull$$$0(1);
        }
        return extensions3;
    }

    private static List<PluginDescriptorCandidate> createCandidates(final Module currentModule, List<DomFileElement<IdeaPlugin>> elements) {
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)currentModule.getProject());
        List groupPath = grouper.getGroupPath(currentModule);
        elements.sort((o1, o2) -> {
            int groupComparison;
            Module module2;
            Module module1 = o1.getModule();
            if (!Comparing.equal((Object)module1, (Object)(module2 = o2.getModule()))) {
                if (currentModule.equals(module1)) {
                    return -1;
                }
                if (currentModule.equals(module2)) {
                    return 1;
                }
            }
            if (module1 != null && module2 != null && (groupComparison = Comparing.compare((int)PluginDescriptorChooser.groupMatchLevel(groupPath, grouper.getGroupPath(module2)), (int)PluginDescriptorChooser.groupMatchLevel(groupPath, grouper.getGroupPath(module1)))) != 0) {
                return groupComparison;
            }
            return ModulesAlphaComparator.INSTANCE.compare(module1, module2);
        });
        elements.sort((o1, o2) -> {
            if (!Comparing.equal((Object)o1.getModule(), (Object)o2.getModule())) {
                return 0;
            }
            String pluginId1 = ((IdeaPlugin)o1.getRootElement()).getPluginId();
            String pluginId2 = ((IdeaPlugin)o2.getRootElement()).getPluginId();
            if (pluginId1 == null && pluginId2 == null) {
                return o1.getFile().getName().compareTo(o2.getFile().getName());
            }
            if (pluginId1 == null) {
                return 1;
            }
            if (pluginId2 == null) {
                return -1;
            }
            return Comparing.compare((Comparable)((Object)pluginId1), (Comparable)((Object)pluginId2));
        });
        return ContainerUtil.map(elements, (Function)new Function<DomFileElement<IdeaPlugin>, PluginDescriptorCandidate>(){
            private Module myLastModule;
            {
                this.myLastModule = currentModule;
            }

            public PluginDescriptorCandidate fun(DomFileElement<IdeaPlugin> element) {
                Module module = element.getModule();
                boolean startsNewGroup = !this.myLastModule.equals(module);
                this.myLastModule = module;
                return new PluginDescriptorCandidate(element, startsNewGroup);
            }
        });
    }

    private static int groupMatchLevel(@NotNull List<String> targetGroupPath, @NotNull List<String> groupPath) {
        if (targetGroupPath == null) {
            PluginDescriptorChooser.$$$reportNull$$$0(2);
        }
        if (groupPath == null) {
            PluginDescriptorChooser.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < Math.min(targetGroupPath.size(), groupPath.size()); ++i) {
            if (targetGroupPath.get(i).equals(groupPath.get(i))) continue;
            return i;
        }
        return Math.min(targetGroupPath.size(), groupPath.size());
    }

    public static List<DomFileElement<IdeaPlugin>> findAppropriateIntelliJModule(String moduleName, List<DomFileElement<IdeaPlugin>> elements) {
        String extensionsFile = INTELLIJ_MODULES.get(moduleName);
        if (extensionsFile != null) {
            for (DomFileElement<IdeaPlugin> element : elements) {
                if (!element.getFile().getName().equals(extensionsFile)) continue;
                return Collections.singletonList(element);
            }
        }
        return elements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetGroupPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateExtensionsForEP";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "groupMatchLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginDescriptorCandidate {
        private final DomFileElement<IdeaPlugin> myDomFileElement;
        private final boolean myStartsNewGroup;

        private PluginDescriptorCandidate(DomFileElement<IdeaPlugin> domFileElement, boolean startsNewGroup) {
            this.myDomFileElement = domFileElement;
            this.myStartsNewGroup = startsNewGroup;
        }

        public String getText() {
            String name = this.myDomFileElement.getFile().getName();
            String pluginId = this.getPluginId();
            return pluginId != null ? name + " [" + pluginId + "]" : name;
        }

        public Icon getIcon() {
            return this.getPluginId() != null ? AllIcons.Nodes.Plugin : EmptyIcon.create((Icon)AllIcons.Nodes.Plugin);
        }

        public String getSeparatorText() {
            if (!this.myStartsNewGroup) {
                return null;
            }
            Module module = this.myDomFileElement.getModule();
            return module == null ? null : module.getName();
        }

        private String getPluginId() {
            return ((IdeaPlugin)this.myDomFileElement.getRootElement()).getPluginId();
        }
    }
}

