/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;

public class ConvertToJBBorderQuickFix
extends LocalQuickFixBase {
    public ConvertToJBBorderQuickFix() {
        super("Convert to JBUI.Borders.empty(...)");
    }

    public ConvertToJBBorderQuickFix(String text) {
        super(text);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiCall newExpression;
        PsiExpressionList list;
        if (project == null) {
            ConvertToJBBorderQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            ConvertToJBBorderQuickFix.$$$reportNull$$$0(1);
        }
        if ((list = (newExpression = (PsiCall)descriptor.getPsiElement()).getArgumentList()) != null && list.getExpressions().length == 4) {
            String right;
            String bottom;
            String left;
            String top = list.getExpressions()[0].getText();
            String text = ConvertToJBBorderQuickFix.isZero(top, left = list.getExpressions()[1].getText(), bottom = list.getExpressions()[2].getText(), right = list.getExpressions()[3].getText()) ? "empty()" : (ConvertToJBBorderQuickFix.isZero(left, bottom, right) ? "emptyTop(" + top + ")" : (ConvertToJBBorderQuickFix.isZero(top, bottom, right) ? "emptyLeft(" + left + ")" : (ConvertToJBBorderQuickFix.isZero(top, left, right) ? "emptyBottom(" + bottom + ")" : (ConvertToJBBorderQuickFix.isZero(top, left, bottom) ? "emptyRight(" + right + ")" : (top.equals(left) && left.equals(bottom) && bottom.equals(right) && right.equals(top) ? "empty(" + top + ")" : (top.equals(bottom) && right.equals(left) ? String.format("empty(%s, %s)", top, left) : String.format("empty(%s, %s, %s, %s)", top, left, bottom, right)))))));
            text = JBUI.class.getName() + ".Borders." + text;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText(text, newExpression.getContext());
            PsiElement newElement = newExpression.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiUtilBase.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    public static boolean canSimplify(PsiMethodCallExpression expression) {
        PsiType[] types = expression.getArgumentList().getExpressionTypes();
        if (types.length != 1 && types.length != 2 && types.length != 4) {
            return false;
        }
        for (PsiType type : types) {
            if (PsiType.INT.equals((Object)type)) continue;
            return false;
        }
        PsiExpression[] params = expression.getArgumentList().getExpressions();
        if (params.length == 1) {
            return params[0].textMatches((CharSequence)"0");
        }
        if (params.length == 2) {
            return ConvertToJBBorderQuickFix.areSame(params);
        }
        if (params.length == 4) {
            if (ConvertToJBBorderQuickFix.areSame(params) || ConvertToJBBorderQuickFix.areSame(params[0], params[2]) && ConvertToJBBorderQuickFix.areSame(params[1], params[3])) {
                return true;
            }
            int zeros = 0;
            for (PsiExpression param : params) {
                zeros += ConvertToJBBorderQuickFix.isZero(param.getText()) ? 1 : 0;
            }
            return zeros == 3;
        }
        return false;
    }

    private static boolean areSame(PsiExpression ... params) {
        if (params.length < 2) {
            return false;
        }
        String gold = params[0].getText();
        for (int i = 1; i < params.length; ++i) {
            if (params[i].textMatches((CharSequence)gold)) continue;
            return false;
        }
        return true;
    }

    private static boolean isZero(String ... args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if ("0".equals(arg)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBBorderQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

