/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;

public class StatefulEpInspection
extends DevKitUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        UField[] fields;
        if (psiClass == null) {
            StatefulEpInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            StatefulEpInspection.$$$reportNull$$$0(1);
        }
        if ((fields = psiClass.getFields()).length == 0) {
            return super.checkClass(psiClass, manager, isOnTheFly);
        }
        boolean isQuickFix = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)LocalQuickFix.class.getCanonicalName());
        ExtensionLocator locator = new ExtensionLocator((PsiClass)psiClass);
        List<ExtensionCandidate> targets = locator.findCandidates();
        if (isQuickFix || !targets.isEmpty()) {
            boolean isProjectComponent = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)ProjectComponent.class.getCanonicalName());
            boolean projectService = ContainerUtil.find(targets, candidate -> {
                XmlTag element = (XmlTag)candidate.pointer.getElement();
                String name = element != null ? element.getName() : null;
                return "projectService".equals(name);
            }) != null;
            ArrayList result = ContainerUtil.newArrayList();
            for (UField field : fields) {
                for (Class c : new Class[]{PsiElement.class, PsiReference.class, Project.class}) {
                    String message;
                    if (c == Project.class && (field.hasModifierProperty("final") || isProjectComponent || projectService)) continue;
                    String string = c == PsiElement.class ? "Potential memory leak: don't hold PsiElement, use SmartPsiElementPointer instead" + (isQuickFix ? "; also see LocalQuickFixOnPsiElement" : "") : (message = "Don't use " + c.getSimpleName() + " as a field in " + (isQuickFix ? "quick fix" : "extension"));
                    if (!InheritanceUtil.isInheritor((PsiType)field.getType(), (String)c.getCanonicalName())) continue;
                    result.add(manager.createProblemDescriptor((PsiElement)field, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                }
            }
            return result.toArray(new ProblemDescriptor[result.size()]);
        }
        return super.checkClass(psiClass, manager, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/StatefulEpInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

