/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

class RegistrationCheckerUtil {
    RegistrationCheckerUtil() {
    }

    @Nullable
    static Set<PsiClass> getRegistrationTypes(PsiClass psiClass, RegistrationType registrationType) {
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        assert (psiFile != null);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return null;
        }
        RegistrationTypeFinder finder = new RegistrationTypeFinder(psiClass, registrationType);
        if (PsiUtil.isIdeaProject(project)) {
            return RegistrationCheckerUtil.checkIdeaProject(project, finder);
        }
        Set<PsiClass> pluginModuleResults = RegistrationCheckerUtil.checkModule(module, finder);
        if (pluginModuleResults != null) {
            return pluginModuleResults;
        }
        List<Module> candidateModules = PluginModuleType.getCandidateModules(module);
        candidateModules.remove(module);
        for (Module candidateModule : candidateModules) {
            Set<PsiClass> types = RegistrationCheckerUtil.checkModule(candidateModule, finder);
            if (types == null) continue;
            return types;
        }
        return null;
    }

    @Nullable
    private static Set<PsiClass> checkIdeaProject(Project project, RegistrationTypeFinder finder) {
        finder.processScope(GlobalSearchScopesCore.projectProductionScope((Project)project));
        return finder.getTypes();
    }

    @Nullable
    private static Set<PsiClass> checkModule(Module module, RegistrationTypeFinder finder) {
        DomFileElement<IdeaPlugin> pluginXml = RegistrationCheckerUtil.getPluginXmlFile(module);
        if (pluginXml == null) {
            return null;
        }
        if (!finder.processScope(GlobalSearchScope.fileScope((PsiFile)pluginXml.getFile()))) {
            return finder.getTypes();
        }
        for (Dependency dependency : ((IdeaPlugin)pluginXml.getRootElement()).getDependencies()) {
            XmlFile depPluginXml;
            DomFileElement<IdeaPlugin> dependentIdeaPlugin;
            PsiElement resolve;
            PathReference configFile;
            GenericAttributeValue<PathReference> configFileAttribute = dependency.getConfigFile();
            if (!DomUtil.hasXml(configFileAttribute) || (configFile = (PathReference)configFileAttribute.getValue()) == null || !((resolve = configFile.resolve()) instanceof XmlFile) || (dependentIdeaPlugin = DescriptorUtil.getIdeaPlugin(depPluginXml = (XmlFile)resolve)) == null || finder.processScope(GlobalSearchScope.fileScope((PsiFile)dependentIdeaPlugin.getFile()))) continue;
            return finder.getTypes();
        }
        return finder.getTypes();
    }

    @Nullable
    private static DomFileElement<IdeaPlugin> getPluginXmlFile(Module module) {
        XmlFile pluginXml = PluginModuleType.getPluginXml(module);
        if (pluginXml == null) {
            return null;
        }
        return DescriptorUtil.getIdeaPlugin(pluginXml);
    }

    private static class RegistrationTypeFinder {
        private final PsiClass myPsiClass;
        private final RegistrationType myRegistrationType;
        private final Set<PsiClass> myTypes = ContainerUtil.newIdentityTroveSet((int)1);

        private RegistrationTypeFinder(PsiClass psiClass, RegistrationType registrationType) {
            this.myPsiClass = psiClass;
            this.myRegistrationType = registrationType;
        }

        private boolean processScope(GlobalSearchScope scope) {
            boolean allComponents;
            boolean findAll = this.myRegistrationType == RegistrationType.ALL;
            boolean bl = allComponents = findAll || this.myRegistrationType == RegistrationType.ALL_COMPONENTS;
            if ((allComponents || this.myRegistrationType == RegistrationType.APPLICATION_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredApplicationComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.APPLICATION.myClassName);
                return false;
            }
            if ((allComponents || this.myRegistrationType == RegistrationType.PROJECT_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredProjectComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.PROJECT.myClassName);
                return false;
            }
            if ((allComponents || this.myRegistrationType == RegistrationType.MODULE_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredModuleComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.MODULE.myClassName);
                return false;
            }
            if ((findAll || this.myRegistrationType == RegistrationType.ACTION) && IdeaPluginRegistrationIndex.isRegisteredAction(this.myPsiClass, scope)) {
                this.addType(ActionType.ACTION.myClassName);
                return false;
            }
            return true;
        }

        private void addType(String fqn) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).findClass(fqn, this.myPsiClass.getResolveScope());
            ContainerUtil.addIfNotNull(this.myTypes, (Object)psiClass);
        }

        private Set<PsiClass> getTypes() {
            return this.myTypes.isEmpty() ? null : this.myTypes;
        }
    }

    static enum RegistrationType {
        ALL,
        ALL_COMPONENTS,
        APPLICATION_COMPONENT,
        PROJECT_COMPONENT,
        MODULE_COMPONENT,
        ACTION;

    }
}

