/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDOutput;
import com.wutka.dtd.DTDParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.jetbrains.idea.devkit.dom.generator.FieldDesc;
import org.jetbrains.idea.devkit.dom.generator.ModelDesc;
import org.jetbrains.idea.devkit.dom.generator.ModelLoader;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.TypeDesc;
import org.jetbrains.idea.devkit.dom.generator.Util;

public class DTDModelLoader
implements ModelLoader {
    private ModelDesc model;

    @Override
    public void loadModel(ModelDesc model, Collection<File> schemas, XMLEntityResolver resolver) throws Exception {
        this.model = model;
        for (File dtdFile : schemas) {
            String fileName = dtdFile.getPath();
            if (dtdFile.isDirectory() || !fileName.endsWith(".dtd") || fileName.endsWith("datatypes.dtd")) {
                Util.log("skipping " + fileName);
                continue;
            }
            Util.log("loading " + fileName + "..");
            String ns = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
            this.loadDTDByWutka(ns, dtdFile);
        }
    }

    private NamespaceDesc ensureNamespaceExists(String ns) {
        if (!this.model.nsdMap.containsKey(ns)) {
            Util.log("Adding default ns desc for: " + ns);
            NamespaceDesc nsd = new NamespaceDesc(ns, this.model.nsdMap.get(""));
            this.model.nsdMap.put(ns, nsd);
        }
        return this.model.nsdMap.get(ns);
    }

    private void loadDTDByWutka(String ns, File dtdFile) throws Exception {
        DTDParser parser = new DTDParser(dtdFile, false);
        DTD dtd = parser.parse(true);
        DTDModelLoader.checkDTDRootElement(dtd);
        this.processDTD(ns, dtd, this.model.jtMap, this.model.nsdMap);
    }

    private void processDTD(String namespace, DTD dtd, Map<String, TypeDesc> jtMap, Map<String, NamespaceDesc> nsdMap) {
        NamespaceDesc nsd = this.ensureNamespaceExists(namespace);
        if (nsd.skip) {
            return;
        }
        ArrayList<String> resultQNames = new ArrayList<String>();
        DTDElement[] elements = new DTDElement[dtd.elements.size()];
        int ptr = 1;
        HashSet<DTDElement> visitedElements = new HashSet<DTDElement>();
        elements[0] = dtd.rootElement;
        while (--ptr > -1) {
            DTDElement el = elements[ptr];
            visitedElements.add(el);
            String typeName = this.model.toJavaTypeName(el.name, namespace);
            String typeQName = this.model.toJavaQualifiedTypeName(namespace, typeName, false);
            if (resultQNames.contains(typeQName)) continue;
            resultQNames.add(typeQName);
            TypeDesc td = new TypeDesc(el.name, namespace, typeName, TypeDesc.TypeEnum.CLASS);
            boolean duplicates = false;
            if (el.content instanceof DTDAny || el.content instanceof DTDMixed) {
                FieldDesc fd = new FieldDesc(6, "value", "String", null, "null", false);
                fd.realIndex = td.fdMap.size();
                td.fdMap.put(fd.name, fd);
            }
            for (Object o : el.attributes.keySet()) {
                String attrName = (String)o;
                DTDAttribute attr = (DTDAttribute)el.attributes.get(attrName);
                if (attr.decl == DTDDecl.FIXED || "ID".equals(attr.type)) continue;
                boolean bl = attr.decl == DTDDecl.REQUIRED;
                FieldDesc fd1 = new FieldDesc(4, Util.toJavaFieldName(attrName), "String", null, "\"\"", bl);
                fd1.tagName = attrName;
                fd1.documentation = "Attribute " + attrName + "";
                fd1.realIndex = td.fdMap.size();
                duplicates = Util.addToNameMap(td.fdMap, fd1, false) || duplicates;
            }
            ArrayList<Vector> choiceList = new ArrayList<Vector>();
            LinkedList<Entry> plist = new LinkedList<Entry>();
            if (el.content instanceof DTDContainer) {
                plist.add(new Entry(el.content, false, true));
            }
            while (!plist.isEmpty()) {
                Entry pentry = (Entry)plist.removeFirst();
                DTDItem p = pentry.p;
                if (p instanceof DTDName) {
                    DTDAttribute attr;
                    DTDName dTDName = (DTDName)p;
                    DTDElement nel = (DTDElement)dtd.elements.get(dTDName.value);
                    String pName = dTDName.value;
                    FieldDesc fd1 = new FieldDesc(1, Util.toJavaFieldName(pName), pName, null, "null", pentry.required && (dTDName.cardinal == DTDCardinal.ONEMANY || dTDName.cardinal == DTDCardinal.NONE));
                    fd1.tagName = pName;
                    if (nel != null) {
                        fd1.documentation = DTDModelLoader.parseDTDItemDocumentation(dtd, (DTDOutput)nel, "Type " + nel.name + " documentation");
                    }
                    if (nel == null) {
                        fd1.type = this.model.toJavaTypeName(fd1.tagName, namespace);
                    } else if (nel.content instanceof DTDEmpty || nel.content instanceof DTDAny) {
                        boolean hasAttrFields = false;
                        boolean hasTextContents = nel.content instanceof DTDAny;
                        for (Object o : nel.attributes.values()) {
                            attr = (DTDAttribute)o;
                            if (attr.decl == DTDDecl.FIXED || "ID".equals(attr.type)) continue;
                            hasAttrFields = true;
                            break;
                        }
                        if (hasAttrFields || hasTextContents) {
                            fd1.clType = 3;
                            fd1.type = this.model.toJavaTypeName(fd1.tagName, namespace);
                            fd1.contentQualifiedName = this.model.toJavaQualifiedTypeName(namespace, fd1.name, false);
                            fd1.def = "null";
                            if (!visitedElements.contains(nel)) {
                                elements[ptr++] = nel;
                            }
                        } else {
                            fd1.clType = 2;
                            fd1.type = "boolean";
                            fd1.def = "false";
                        }
                    } else if (nel.content instanceof DTDContainer) {
                        boolean hasAttrFields = false;
                        boolean hasTextField = false;
                        if (nel.content instanceof DTDMixed && ((DTDMixed)nel.content).getItemsVec().size() == 1) {
                            hasTextField = true;
                            for (Object o : nel.attributes.values()) {
                                attr = (DTDAttribute)o;
                                if (attr.decl == DTDDecl.FIXED || "ID".equals(attr.type)) continue;
                                hasAttrFields = true;
                                break;
                            }
                        }
                        if (hasTextField && !hasAttrFields) {
                            fd1.clType = 1;
                            fd1.type = "String";
                            fd1.def = "null";
                        } else {
                            fd1.clType = 3;
                            fd1.type = this.model.toJavaTypeName(fd1.tagName, namespace);
                            fd1.contentQualifiedName = this.model.toJavaQualifiedTypeName(namespace, fd1.tagName, false);
                            if (!visitedElements.contains(nel)) {
                                elements[ptr++] = nel;
                            }
                        }
                    } else {
                        fd1.type = "ERROR:Name";
                    }
                    if ((pentry.many || dTDName.cardinal.type >= 2) && fd1.clType != 2) {
                        fd1.elementType = fd1.type;
                        fd1.elementName = fd1.name;
                        fd1.type = "List<" + fd1.elementType + ">";
                        fd1.name = Util.pluralize(fd1.name);
                        fd1.def = "new ArrayList(0)";
                        fd1.clType = -fd1.clType;
                        fd1.comment = "array of " + fd1.elementType;
                    }
                    fd1.realIndex = td.fdMap.size();
                    duplicates = Util.addToNameMap(td.fdMap, fd1, false) || duplicates;
                    continue;
                }
                if (p instanceof DTDContainer) {
                    DTDContainer dTDContainer = (DTDContainer)p;
                    boolean isChoice = dTDContainer instanceof DTDChoice;
                    boolean required = !isChoice && pentry.required && p.cardinal != DTDCardinal.ZEROMANY && p.cardinal != DTDCardinal.OPTIONAL;
                    boolean many = p.cardinal == DTDCardinal.ONEMANY || p.cardinal == DTDCardinal.ZEROMANY;
                    Vector l = dTDContainer.getItemsVec();
                    if (!many && isChoice) {
                        choiceList.add(l);
                    }
                    for (DTDItem aL : l) {
                        plist.add(new Entry(aL, many, required));
                    }
                    continue;
                }
                Util.logerr("unknown item " + p);
            }
            td.duplicates = duplicates;
            td.documentation = DTDModelLoader.parseDTDItemDocumentation(dtd, (DTDOutput)el, "Type " + el.name + " documentation");
            jtMap.put(this.model.toJavaQualifiedTypeName(namespace, td.name, false), td);
            int i = 0;
            for (FieldDesc fieldDesc : td.fdMap.values()) {
                fieldDesc.idx = i++;
            }
            for (List list : choiceList) {
                ArrayList<DTDItem> clist = new ArrayList<DTDItem>();
                LinkedList elist = new LinkedList();
                for (i = 0; i < list.size(); ++i) {
                    elist.add(list.get(i));
                }
                while (!elist.isEmpty()) {
                    DTDItem p = (DTDItem)elist.removeFirst();
                    if (p instanceof DTDContainer) {
                        Vector l2 = ((DTDContainer)p).getItemsVec();
                        for (DTDItem aL2 : l2) {
                            elist.addFirst(aL2);
                        }
                        continue;
                    }
                    if (!(p instanceof DTDName)) continue;
                    clist.add(p);
                }
                boolean choiceOpt = true;
                FieldDesc[] choice = new FieldDesc[clist.size()];
                for (i = 0; i < choice.length; ++i) {
                    DTDName p = (DTDName)clist.get(i);
                    String s = Util.toJavaFieldName(p.value);
                    FieldDesc fd = td.fdMap.get(s);
                    if (fd == null && (fd = td.fdMap.get(Util.pluralize(s))) == null) {
                        Util.logerr("uknown choice element: " + s);
                        continue;
                    }
                    choice[i] = fd;
                    choice[i].choice = choice;
                    if (!fd.required) continue;
                    choiceOpt = false;
                }
                for (i = 0; i < choice.length; ++i) {
                    choice[i].choiceOpt = choiceOpt;
                }
            }
        }
        Vector entList = dtd.getItemsByType(DTDEntity.class);
        for (DTDEntity entity : entList) {
            String value = entity.value;
            if (!value.startsWith("(") || !value.endsWith(")")) continue;
            String typeName = this.model.toJavaTypeName(entity.name, namespace);
            TypeDesc td = new TypeDesc(entity.name, namespace, typeName, TypeDesc.TypeEnum.ENUM);
            StringTokenizer st = new StringTokenizer(value, "(|)");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                td.fdMap.put(s, new FieldDesc(Util.computeEnumConstantName(s, td.name), s));
            }
            td.documentation = DTDModelLoader.parseDTDItemDocumentation(dtd, (DTDOutput)entity, "Type " + entity.name + " documentation");
            jtMap.put(this.model.toJavaQualifiedTypeName(namespace, td.name, true), td);
        }
    }

    private static String parseDTDItemDocumentation(DTD dtd, DTDOutput obj, String title) {
        int elementIndex = dtd.items.indexOf(obj);
        if (elementIndex < 1) {
            return null;
        }
        Object prev = dtd.items.get(elementIndex - 1);
        if (!(prev instanceof DTDComment)) {
            return null;
        }
        DTDComment comment = (DTDComment)prev;
        return title + "\n<pre>\n" + comment.getText() + "\n</pre>";
    }

    private static void checkDTDRootElement(DTD dtd) throws Exception {
        if (dtd.rootElement == null) {
            StringBuffer sb = new StringBuffer("Empty root: possible elements: ");
            HashMap map = new HashMap(dtd.elements);
            for (Object o : dtd.elements.values()) {
                DTDElement el = (DTDElement)o;
                if (!(el.content instanceof DTDContainer)) continue;
                for (Object obj : ((DTDContainer)el.content).getItemsVec()) {
                    if (!(obj instanceof DTDName)) continue;
                    map.remove(((DTDName)obj).value);
                }
            }
            if (dtd.rootElement != null) {
                return;
            }
            sb.append(map.size()).append(map.keySet());
            throw new Exception(sb.toString());
        }
    }

    static class Entry {
        boolean required;
        boolean many;
        DTDItem p;
        Entry parent;
        DTDItem it;
        Vector choice;
        int num;

        Entry(DTDItem p, boolean many, boolean required) {
            this.required = required;
            this.many = many;
            this.p = p;
        }

        Entry(Entry parent, DTDItem it, Vector choice, int num) {
            this.parent = parent;
            this.it = it;
            this.choice = choice;
            this.num = num;
        }
    }
}

