/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.ActionData;
import org.jetbrains.idea.devkit.util.ActionType;

public class NewActionDialog
extends DialogWrapper
implements ActionData {
    private JPanel myRootPanel;
    private JList myGroupList;
    private JList myActionList;
    private JTextField myActionNameEdit;
    private JTextField myActionIdEdit;
    private JTextField myActionTextEdit;
    private JTextField myActionDescriptionEdit;
    private JRadioButton myAnchorFirstRadio;
    private JRadioButton myAnchorLastRadio;
    private JRadioButton myAnchorBeforeRadio;
    private JRadioButton myAnchorAfterRadio;
    private JPanel myShortcutPanel;
    private JPanel myFirstKeystrokeEditPlaceholder;
    private JPanel mySecondKeystrokeEditPlaceholder;
    private JButton myClearFirstKeystroke;
    private JButton myClearSecondKeystroke;
    private ShortcutTextField myFirstKeystrokeEdit;
    private ShortcutTextField mySecondKeystrokeEdit;
    private TextFieldWithBrowseButton myIconEdit;
    private Project myProject;
    private ButtonGroup myAnchorButtonGroup;

    public NewActionDialog(@NotNull PsiClass actionClass) {
        if (actionClass == null) {
            NewActionDialog.$$$reportNull$$$0(0);
        }
        this(actionClass.getProject());
        this.myActionNameEdit.setText(actionClass.getQualifiedName());
        this.myActionNameEdit.setEditable(false);
        this.myActionIdEdit.setText(actionClass.getQualifiedName());
        if (ActionType.GROUP.isOfType(actionClass)) {
            this.myShortcutPanel.setVisible(false);
        }
    }

    protected NewActionDialog(Project project) {
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(DevKitBundle.message("new.action.dialog.title", new Object[0]));
        final ActionManager actionManager = ActionManager.getInstance();
        Object[] actionIds = actionManager.getActionIds("");
        Arrays.sort(actionIds);
        ArrayList<ActionGroup> actionGroups = new ArrayList<ActionGroup>();
        for (Object actionId : actionIds) {
            AnAction anAction;
            if (!actionManager.isGroup((String)actionId) || !((anAction = actionManager.getAction((String)actionId)) instanceof DefaultActionGroup)) continue;
            actionGroups.add((ActionGroup)anAction);
        }
        this.myGroupList.setListData(actionGroups.toArray());
        this.myGroupList.setCellRenderer(new MyActionRenderer());
        this.myGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ActionGroup group = (ActionGroup)NewActionDialog.this.myGroupList.getSelectedValue();
                if (group == null) {
                    NewActionDialog.this.myActionList.setListData(ArrayUtil.EMPTY_OBJECT_ARRAY);
                } else {
                    AnAction[] actions = group.getChildren(null);
                    ArrayList<AnAction> realActions = new ArrayList<AnAction>();
                    for (AnAction action : actions) {
                        if (actionManager.getId(action) == null) continue;
                        realActions.add(action);
                    }
                    NewActionDialog.this.myActionList.setListData(realActions.toArray());
                }
            }
        });
        new ListSpeedSearch(this.myGroupList, o -> ActionManager.getInstance().getId((AnAction)o));
        this.myActionList.setCellRenderer(new MyActionRenderer());
        this.myActionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NewActionDialog.this.updateControls();
            }
        });
        MyDocumentListener listener = new MyDocumentListener();
        this.myActionIdEdit.getDocument().addDocumentListener(listener);
        this.myActionNameEdit.getDocument().addDocumentListener(listener);
        this.myActionTextEdit.getDocument().addDocumentListener(listener);
        this.myAnchorButtonGroup.setSelected(this.myAnchorFirstRadio.getModel(), true);
        this.myFirstKeystrokeEdit = new ShortcutTextField();
        this.myFirstKeystrokeEditPlaceholder.setLayout(new BorderLayout());
        this.myFirstKeystrokeEditPlaceholder.add((Component)this.myFirstKeystrokeEdit, "Center");
        this.myClearFirstKeystroke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewActionDialog.this.myFirstKeystrokeEdit.setKeyStroke(null);
            }
        });
        this.myFirstKeystrokeEdit.getDocument().addDocumentListener(listener);
        this.myClearFirstKeystroke.setText(null);
        Icon icon = AllIcons.Actions.Cancel;
        Dimension size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.myClearFirstKeystroke.setIcon(icon);
        this.myClearFirstKeystroke.setPreferredSize(size);
        this.myClearFirstKeystroke.setMaximumSize(size);
        this.mySecondKeystrokeEdit = new ShortcutTextField();
        this.mySecondKeystrokeEditPlaceholder.setLayout(new BorderLayout());
        this.mySecondKeystrokeEditPlaceholder.add((Component)this.mySecondKeystrokeEdit, "Center");
        this.myClearSecondKeystroke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewActionDialog.this.mySecondKeystrokeEdit.setKeyStroke(null);
            }
        });
        this.mySecondKeystrokeEdit.getDocument().addDocumentListener(listener);
        this.myClearSecondKeystroke.setText(null);
        this.myClearSecondKeystroke.setIcon(icon);
        this.myClearSecondKeystroke.setPreferredSize(size);
        this.myClearSecondKeystroke.setMaximumSize(size);
        this.updateControls();
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myActionIdEdit;
    }

    @Override
    @NotNull
    public String getActionId() {
        String string = this.myActionIdEdit.getText();
        if (string == null) {
            NewActionDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getActionName() {
        return this.myActionNameEdit.getText();
    }

    @Override
    @NotNull
    public String getActionText() {
        String string = this.myActionTextEdit.getText();
        if (string == null) {
            NewActionDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getActionDescription() {
        return this.myActionDescriptionEdit.getText();
    }

    @Override
    @Nullable
    public String getSelectedGroupId() {
        ActionGroup group = (ActionGroup)this.myGroupList.getSelectedValue();
        return group == null ? null : ActionManager.getInstance().getId((AnAction)group);
    }

    @Override
    @Nullable
    public String getSelectedActionId() {
        AnAction action = (AnAction)this.myActionList.getSelectedValue();
        return action == null ? null : ActionManager.getInstance().getId(action);
    }

    @Override
    @NonNls
    public String getSelectedAnchor() {
        ButtonModel selection = this.myAnchorButtonGroup.getSelection();
        if (selection == this.myAnchorFirstRadio.getModel()) {
            return "first";
        }
        if (selection == this.myAnchorLastRadio.getModel()) {
            return "last";
        }
        if (selection == this.myAnchorBeforeRadio.getModel()) {
            return "before";
        }
        if (selection == this.myAnchorAfterRadio.getModel()) {
            return "after";
        }
        return null;
    }

    @Override
    public String getFirstKeyStroke() {
        return NewActionDialog.getKeystrokeText(this.myFirstKeystrokeEdit.getKeyStroke());
    }

    @Override
    public String getSecondKeyStroke() {
        return NewActionDialog.getKeystrokeText(this.mySecondKeystrokeEdit.getKeyStroke());
    }

    private static String getKeystrokeText(KeyStroke keyStroke) {
        return keyStroke != null ? keyStroke.toString().replaceAll("pressed ", "").replaceAll("released ", "") : null;
    }

    private void updateControls() {
        this.setOKActionEnabled(this.myActionIdEdit.getText().length() > 0 && this.myActionNameEdit.getText().length() > 0 && this.myActionTextEdit.getText().length() > 0 && (!this.myActionNameEdit.isEditable() || PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myActionNameEdit.getText())));
        this.myAnchorBeforeRadio.setEnabled(this.myActionList.getSelectedValue() != null);
        this.myAnchorAfterRadio.setEnabled(this.myActionList.getSelectedValue() != null);
        boolean enabled = this.myFirstKeystrokeEdit.getDocument().getLength() > 0;
        this.myClearFirstKeystroke.setEnabled(enabled);
        this.mySecondKeystrokeEdit.setEnabled(enabled);
        this.myClearSecondKeystroke.setEnabled(enabled);
        enabled = enabled && this.mySecondKeystrokeEdit.getDocument().getLength() > 0;
        this.myClearSecondKeystroke.setEnabled(enabled);
    }

    protected String getHelpId() {
        return "reference.new.action.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/NewActionDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/NewActionDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.add.to.group"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myGroupList = jBList;
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.actions"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList2 = new JBList();
        this.myActionList = jBList2;
        jBList2.setSelectionMode(0);
        jBScrollPane2.setViewportView((Component)jBList2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "");
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 2, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.anchor"), 0, 0, null, null));
        this.myAnchorFirstRadio = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.anchor.first"));
        jPanel6.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAnchorLastRadio = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.anchor."));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAnchorBeforeRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.anchor.before"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAnchorAfterRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.anchor.after"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.group.groups"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myActionNameEdit = jTextField4 = new JTextField();
        jPanel7.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.id"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myActionTextEdit = jTextField3 = new JTextField();
        jPanel7.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myActionDescriptionEdit = jTextField2 = new JTextField();
        jPanel7.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.description"));
        jPanel7.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.class.name"));
        jPanel7.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.text"));
        jPanel7.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myActionIdEdit = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myShortcutPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.shortcuts"), (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.first"));
        jPanel3.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.second"));
        jPanel3.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFirstKeystrokeEditPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.mySecondKeystrokeEditPlaceholder = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myClearFirstKeystroke = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.clear"));
        jButton2.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.clear.tooltip"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        this.myClearSecondKeystroke = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.clear"));
        jButton.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.action.keyboard.clear.tooltip"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        jLabel.setLabelFor((Component)jBScrollPane2);
        jLabel2.setLabelFor((Component)jBScrollPane);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField4);
        jLabel6.setLabelFor(jTextField3);
        this.myAnchorButtonGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ShortcutTextField
    extends JTextField {
        private KeyStroke myKeyStroke;

        public ShortcutTextField() {
            this.enableEvents(8L);
            this.setFocusTraversalKeysEnabled(false);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                int keyCode = e.getKeyCode();
                if (keyCode == 16 || keyCode == 18 || keyCode == 17 || keyCode == 65406 || keyCode == 157) {
                    return;
                }
                this.setKeyStroke(KeyStroke.getKeyStroke(keyCode, e.getModifiers()));
            }
        }

        public void setKeyStroke(KeyStroke keyStroke) {
            this.myKeyStroke = keyStroke;
            if (keyStroke == null) {
                this.setText("");
            } else {
                this.setText(KeymapUtil.getKeystrokeText((KeyStroke)keyStroke));
            }
        }

        public KeyStroke getKeyStroke() {
            return this.myKeyStroke;
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NewActionDialog.this.updateControls();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NewActionDialog.this.updateControls();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NewActionDialog.this.updateControls();
        }
    }

    private static class MyActionRenderer
    extends ColoredListCellRenderer {
        private MyActionRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyActionRenderer.$$$reportNull$$$0(0);
            }
            AnAction group = (AnAction)value;
            this.append(ActionManager.getInstance().getId(group), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String text = group.getTemplatePresentation().getText();
            if (text != null) {
                this.append(" (" + text + ")", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/devkit/actions/NewActionDialog$MyActionRenderer", "customizeCellRenderer"));
        }
    }
}

