/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewActionDialog;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class NewActionAction
extends CreateElementActionBase
implements DescriptorUtil.Patcher {
    private static final PsiClass[] CANCELED = new PsiClass[1];
    private NewActionDialog myDialog;
    private XmlFile pluginDescriptorToPatch;

    public NewActionAction() {
        super(DevKitBundle.message("new.menu.action.text", new Object[0]), DevKitBundle.message("new.menu.action.description", new Object[0]), null);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        PsiElement[] psiElements = this.doInvokeDialog(project, directory);
        PsiElement[] psiElementArray = psiElements == CANCELED ? PsiElement.EMPTY_ARRAY : psiElements;
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiElement[] doInvokeDialog(Project project, PsiDirectory directory) {
        this.myDialog = new NewActionDialog(project);
        try {
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                this.pluginDescriptorToPatch = DevkitActionsUtil.choosePluginModuleDescriptor(directory);
                if (this.pluginDescriptorToPatch != null) {
                    CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
                    validator.canClose(this.myDialog.getActionName());
                    PsiElement[] psiElementArray = validator.getCreatedElements();
                    return psiElementArray;
                }
            }
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            return psiElementArray;
        }
        finally {
            this.myDialog = null;
            this.pluginDescriptorToPatch = null;
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)dataContext.getData(LangDataKeys.MODULE);
        if (module == null || !PsiUtil.isPluginModule(module)) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, JavaCreateTemplateInPackageAction::doCheckPackageExists);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiClass createdClass = DevkitActionsUtil.createSingleClass(newName, "Action.java", directory);
        DescriptorUtil.patchPluginXml(this, createdClass, this.pluginDescriptorToPatch);
        PsiElement[] psiElementArray = new PsiElement[]{createdClass};
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        ActionType.ACTION.patchPluginXml(pluginXml, klass, this.myDialog);
    }

    protected String getErrorTitle() {
        return DevKitBundle.message("new.action.error", new Object[0]);
    }

    protected String getCommandName() {
        return DevKitBundle.message("new.action.command", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return DevKitBundle.message("new.action.action.name", directory, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/actions/NewActionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

