/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.model.GuiceInjectorManager;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.beans.BindToProviderDescriptor;
import com.intellij.guice.model.renderers.GuiceBindingClassPsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import icons.GuiceIcons;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceBindingClassAnnotator
extends RelatedItemLineMarkerProvider {
    private final PsiElementListCellRenderer BINDING_CLASS_CELL_RENDERER = new GuiceBindingClassPsiElementListCellRenderer();
    public static final NotNullFunction<BindDescriptor, Collection<? extends PsiElement>> DEFAULT_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getBindExpression());

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            GuiceBindingClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            GuiceBindingClassAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiClass) {
            Set<BindDescriptor> descriptors = GuiceInjectorManager.getBindingDescriptors(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
            HashSet bindingDescriptors = new HashSet();
            for (BindDescriptor descriptor : descriptors) {
                PsiClass providerClass;
                PsiClass boundClass = descriptor.getBoundClass();
                if (psiElement.equals(boundClass)) {
                    bindingDescriptors.add(descriptor);
                    continue;
                }
                if (psiElement.equals(GuiceBindingClassAnnotator.getBindingBaseClass(descriptor.getBindingClass()))) {
                    bindingDescriptors.add(descriptor);
                    continue;
                }
                if (!(descriptor instanceof BindToProviderDescriptor) || !psiElement.equals(GuiceBindingClassAnnotator.getBindingBaseClass(providerClass = ((BindToProviderDescriptor)descriptor).getProviderClass()))) continue;
                bindingDescriptors.add(descriptor);
            }
            if (bindingDescriptors.size() > 0) {
                NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)GuiceIcons.Google_small, DEFAULT_CONVERTOR).setPopupTitle(GuiceBundle.message("GuiceClassAnnotator.popup.title", new Object[0])).setTooltipText(GuiceBundle.message("GuiceClassAnnotator.popup.tooltip.text", new Object[0])).setCellRenderer(this.BINDING_CLASS_CELL_RENDERER).setTargets((Collection)bindingDescriptors);
                PsiIdentifier identifier = ((PsiClass)psiElement).getNameIdentifier();
                if (identifier != null) {
                    result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
                }
            }
        }
    }

    @Nullable
    private static PsiClass getBindingBaseClass(@Nullable PsiClass bindingClass) {
        if (bindingClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)bindingClass).getBaseClassType().resolve();
        }
        return bindingClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/guice/model/GuiceBindingClassAnnotator";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

