/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.inspections.DeleteBindingFix;
import com.intellij.guice.utils.AnnotationUtils;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantToBindingInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("redundant.to.binding.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantToBindingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return new DeleteBindingFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/RedundantToBindingInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"to".equals(methodName)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)arg).getOperand();
            PsiType classType = classTypeElement.getType();
            if (!(classType instanceof PsiClassType)) {
                return;
            }
            PsiClass referentClass = ((PsiClassType)classType).resolve();
            if (referentClass == null) {
                return;
            }
            PsiClass boundClass = GuiceUtils.findImplementedClassForBinding(expression);
            if (boundClass == null) {
                return;
            }
            if (GuiceUtils.findAnnotatedWithCallForBinding(expression) != null) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)boundClass, (String)"com.google.inject.ProvidedBy", (boolean)true)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)boundClass, (String)"com.google.inject.ImplementedBy", (boolean)true)) {
                PsiAnnotation implementedByAnnotation = boundClass.getModifierList().findAnnotation("com.google.inject.ImplementedBy");
                if (implementedByAnnotation == null) {
                    return;
                }
                PsiElement defaultValue = AnnotationUtils.findDefaultValue(implementedByAnnotation);
                if (defaultValue == null) {
                    return;
                }
                if (!(defaultValue instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiTypeElement implementByClass = ((PsiClassObjectAccessExpression)defaultValue).getOperand();
                PsiType implmenetedByClass = implementByClass.getType();
                if (!(implmenetedByClass instanceof PsiClassType)) {
                    return;
                }
                PsiClass implementedByClass = ((PsiClassType)implmenetedByClass).resolve();
                if (referentClass.equals(implementedByClass)) {
                    this.registerError((PsiElement)classTypeElement, new Object[0]);
                }
            } else if (boundClass.equals(referentClass)) {
                this.registerError((PsiElement)classTypeElement, new Object[0]);
            }
        }
    }
}

