/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.guice.inspections.DeleteBindingFix;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantScopeBindingInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("redundant.scope.binding.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantScopeBindingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return new DeleteBindingFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/RedundantScopeBindingInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"in".equals(methodName)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (!(arg instanceof PsiReferenceExpression)) {
                return;
            }
            String annotation = GuiceUtils.getScopeAnnotationForScopeExpression(arg);
            if (annotation == null) {
                return;
            }
            PsiClass boundClass = GuiceUtils.findImplementedClassForBinding(expression);
            if (boundClass == null) {
                return;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)boundClass, (String)annotation, (boolean)true)) {
                return;
            }
            this.registerError((PsiElement)arg, new Object[0]);
        }
    }
}

