/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBindingInspection
extends BaseInspection {
    private static final Logger LOGGER = Logger.getInstance((String)"PointlessBindingInspection");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("pointless.binding.problem.descriptor", new Object[0]);
        if (string == null) {
            PointlessBindingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return new DeleteBindingFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/PointlessBindingInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"bind".equals(methodName)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiTypeElement classTypeElement = ((PsiClassObjectAccessExpression)arg).getOperand();
            PsiType classType = classTypeElement.getType();
            if (!(classType instanceof PsiClassType)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiClass psiClass = ((PsiClassType)classType).resolve();
            if (psiClass != null && Visitor.usesInject(psiClass)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean usesInject(PsiClass aClass) {
            for (PsiMethod psiMethod : aClass.getAllMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, GuiceAnnotations.INJECTS, (boolean)true)) continue;
                return true;
            }
            for (PsiMethod psiMethod : aClass.getAllFields()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, GuiceAnnotations.INJECTS, (boolean)true)) continue;
                return true;
            }
            return false;
        }
    }

    private static class DeleteBindingFix
    implements LocalQuickFix {
        private DeleteBindingFix() {
        }

        @NotNull
        public String getName() {
            String string = GuiceBundle.message("delete.binding", new Object[0]);
            if (string == null) {
                DeleteBindingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("" == null) {
                DeleteBindingFix.$$$reportNull$$$0(1);
            }
            return "";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeleteBindingFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeleteBindingFix.$$$reportNull$$$0(3);
            }
            PsiMethodCallExpression element = (PsiMethodCallExpression)descriptor.getPsiElement();
            try {
                element.getParent().delete();
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/guice/inspections/PointlessBindingInspection$DeleteBindingFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/guice/inspections/PointlessBindingInspection$DeleteBindingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

