/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.util.Lists;
import org.fest.util.Preconditions;

public final class Throwables {
    private Throwables() {
    }

    public static void appendStackTraceInCurentThreadToThrowable(@Nonnull Throwable t, @Nonnull String startingMethod) {
        ArrayList<Object> stackTrace = Lists.newArrayList((Object[])Preconditions.checkNotNull(t.getStackTrace()));
        stackTrace.addAll(Throwables.filteredStackTrace(startingMethod));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    @Nonnull
    private static List<StackTraceElement> filteredStackTrace(@Nonnull String startingMethod) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (startingMethod.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        StackTraceElement[] stackTrace = Preconditions.checkNotNull(Thread.currentThread().getStackTrace());
        return Lists.newArrayList(stackTrace);
    }

    public static void removeFestRelatedElementsFromStackTrace(@Nonnull Throwable throwable) {
        StackTraceElement[] stackTrace = Preconditions.checkNotNull(throwable.getStackTrace());
        ArrayList<StackTraceElement> filtered = Lists.newArrayList(stackTrace);
        StackTraceElement previous = null;
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getClassName().contains("org.fest")) {
                filtered.remove(element);
                if (previous != null && previous.getClassName().equals("java.lang.reflect.Constructor") && element.getClassName().contains("org.fest.assertions.error.ConstructorInvoker")) {
                    filtered.remove(previous);
                }
            }
            previous = element;
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[filtered.size()]);
        throwable.setStackTrace(newStackTrace);
    }
}

