/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DataType;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUtil {
    private JdbcUtil() {
    }

    public static boolean setCatalogSafe(@NotNull Connection connection, @Nullable String catalog) {
        if (connection == null) {
            JdbcUtil.$$$reportNull$$$0(0);
        }
        try {
            if (catalog != null) {
                connection.setCatalog(catalog);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> resultSetToListSafe(@NotNull ResultSet rs, @NotNull String columnName, @Nullable PairConsumer<String, Throwable> errorSink) {
        if (rs == null) {
            JdbcUtil.$$$reportNull$$$0(1);
        }
        if (columnName == null) {
            JdbcUtil.$$$reportNull$$$0(2);
        }
        ArrayList<Object> retVal = new ArrayList<Object>();
        try {
            while (rs.next()) {
                retVal.add(rs.getObject(columnName));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            JdbcUtil.columnNotAvailable(columnName, errorSink, e);
        }
        finally {
            JdbcUtil.closeResultSetSafe(rs);
        }
        ArrayList<Object> arrayList = retVal;
        if (arrayList == null) {
            JdbcUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void columnNotAvailable(@NotNull String columnName, @Nullable PairConsumer<String, Throwable> errorSink, Exception e) {
        if (columnName == null) {
            JdbcUtil.$$$reportNull$$$0(4);
        }
        String message = e.getMessage();
        if (errorSink != null) {
            errorSink.consume(message != null && message.contains(columnName) ? null : columnName + " unavailable", (Object)e);
        }
    }

    @NotNull
    public static String resultSetToStringSafe(@NotNull ResultSet rs) {
        if (rs == null) {
            JdbcUtil.$$$reportNull$$$0(5);
        }
        String string = JdbcUtil.resultSetToStringSafe(rs, 100, null);
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String resultSetRowToStringSafe(@NotNull ResultSet rs) {
        if (rs == null) {
            JdbcUtil.$$$reportNull$$$0(7);
        }
        String string = JdbcUtil.resultSetToStringSafe(rs, 0, null);
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String resultSetToStringSafe(@NotNull ResultSet rs, int maxRows, @Nullable PairConsumer<String, Throwable> errorSink) {
        StringBuilder sb;
        block11: {
            if (rs == null) {
                JdbcUtil.$$$reportNull$$$0(9);
            }
            sb = new StringBuilder();
            try {
                int n;
                ResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                String[] columnNames = new String[count];
                for (int i = 1; i <= count; ++i) {
                    columnNames[i - 1] = metaData.getColumnName(i);
                    if (maxRows == 0) continue;
                    sb.append(i).append(".").append(columnNames[i - 1]).append("\n");
                }
                for (n = 0; n == 0 && maxRows == 0 || rs.next(); ++n) {
                    if (maxRows >= 0 && n > maxRows) continue;
                    if (n > 0) {
                        sb.append("\n");
                    }
                    sb.append("[").append(n + 1).append("] ");
                    for (int i = 1; i <= count; ++i) {
                        if (i > 1) {
                            sb.append(", ");
                        }
                        sb.append(maxRows == 0 ? columnNames[i - 1] : Integer.valueOf(i)).append(":").append(rs.getObject(i));
                    }
                }
                if (maxRows > 0) {
                    sb.insert(0, n > 0 ? n + " rows total\n" : "no data\n");
                }
            }
            catch (SQLException metaData) {
            }
            catch (Exception e) {
                if (errorSink == null) break block11;
                errorSink.consume((Object)"row unavailable", (Object)e);
            }
        }
        String string = sb.toString();
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static Map<String, Object> resultSetRowToMapSafe(@NotNull ResultSet rs) {
        LinkedHashMap linkedHashMap;
        if (rs == null) {
            JdbcUtil.$$$reportNull$$$0(11);
        }
        try {
            LinkedHashMap result = ContainerUtil.newLinkedHashMap();
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                result.put(metaData.getColumnName(i), rs.getObject(i));
            }
            linkedHashMap = result;
        }
        catch (Exception exception) {
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                JdbcUtil.$$$reportNull$$$0(13);
            }
            return map;
        }
        if (linkedHashMap == null) {
            JdbcUtil.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @Nullable
    public static String getStringSafe(ResultSet resultSet, String columnName, PairConsumer<String, Throwable> errorSink) {
        try {
            return resultSet.getString(columnName);
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            JdbcUtil.columnNotAvailable(columnName, errorSink, e);
        }
        return null;
    }

    public static void closeResultSetSafe(@Nullable ResultSet resultSet) {
        JdbcUtil.closeSafe(resultSet);
    }

    public static void closeStatementSafe(@Nullable Statement statement) {
        JdbcUtil.closeSafe(statement);
    }

    public static void closeConnectionSafe(@Nullable Connection connection) {
        JdbcUtil.closeSafe(connection);
    }

    public static void closeSafe(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            JdbcNativeUtil.performSafe(closeable::close);
        }
    }

    public static boolean hasScaleAndPrecision(int jdbcType) {
        switch (jdbcType) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasLength(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(14);
        }
        String string = JdbcUtil.getJdbcTypeName(dataType, true);
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType, boolean addLength) {
        String typeName;
        String sqlType;
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(16);
        }
        if (StringUtil.isNotEmpty((String)(sqlType = dataType.typeName)) && sqlType.indexOf(40) > -1) {
            String string = sqlType;
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        String string = typeName = StringUtil.isNotEmpty((String)sqlType) ? sqlType : JdbcUtil.getJdbcTypeName(jdbcType);
        if (addLength) {
            int scale;
            boolean hasLength = JdbcUtil.hasLength(jdbcType);
            boolean hasScaleAndPrecision = !hasLength && JdbcUtil.hasScaleAndPrecision(jdbcType);
            int length = hasLength || hasScaleAndPrecision ? dataType.getLength() : -1;
            int n = scale = hasScaleAndPrecision ? dataType.getScale() : -1;
            if (hasLength && length > 0) {
                String string2 = typeName + "(" + length + ")";
                if (string2 == null) {
                    JdbcUtil.$$$reportNull$$$0(18);
                }
                return string2;
            }
            if (hasScaleAndPrecision && length > 0 && scale >= 0) {
                String string3 = typeName + "(" + length + ", " + scale + ")";
                if (string3 == null) {
                    JdbcUtil.$$$reportNull$$$0(19);
                }
                return string3;
            }
        }
        String string4 = typeName;
        if (string4 == null) {
            JdbcUtil.$$$reportNull$$$0(20);
        }
        return string4;
    }

    @NotNull
    public static String getJdbcTypeName(int jdbcType) {
        String result;
        switch (jdbcType) {
            case -7: {
                result = "BIT";
                break;
            }
            case -6: {
                result = "TINYINT";
                break;
            }
            case 5: {
                result = "SMALLINT";
                break;
            }
            case 4: {
                result = "INTEGER";
                break;
            }
            case -5: {
                result = "BIGINT";
                break;
            }
            case 6: {
                result = "FLOAT";
                break;
            }
            case 7: {
                result = "REAL";
                break;
            }
            case 8: {
                result = "DOUBLE";
                break;
            }
            case 2: {
                result = "NUMERIC";
                break;
            }
            case 3: {
                result = "DECIMAL";
                break;
            }
            case 1: {
                result = "CHAR";
                break;
            }
            case 12: {
                result = "VARCHAR";
                break;
            }
            case -1: {
                result = "LONGVARCHAR";
                break;
            }
            case 91: {
                result = "DATE";
                break;
            }
            case 92: {
                result = "TIME";
                break;
            }
            case 93: {
                result = "TIMESTAMP";
                break;
            }
            case -2: {
                result = "BINARY";
                break;
            }
            case -3: {
                result = "VARBINARY";
                break;
            }
            case -4: {
                result = "LONGVARBINARY";
                break;
            }
            case 0: {
                result = "NULL";
                break;
            }
            case 1111: {
                result = "OTHER";
                break;
            }
            case 2000: {
                result = "JAVA_OBJECT";
                break;
            }
            case 2001: {
                result = "DISTINCT";
                break;
            }
            case 2002: {
                result = "STRUCT";
                break;
            }
            case 2003: {
                result = "ARRAY";
                break;
            }
            case 2004: {
                result = "BLOB";
                break;
            }
            case 2005: {
                result = "CLOB";
                break;
            }
            case 2006: {
                result = "REF";
                break;
            }
            case 70: {
                result = "DATALINK";
                break;
            }
            case 16: {
                result = "BOOLEAN";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        String string = result;
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static int guessJdbcTypeByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return 1111;
        }
        String fixed = name.toUpperCase();
        if (fixed.contains("BINARY")) {
            return -3;
        }
        if (fixed.contains("BIT")) {
            return -7;
        }
        if (fixed.contains("BOOL")) {
            return 16;
        }
        if (fixed.contains("DATE")) {
            return 91;
        }
        if (fixed.contains("TIMESTAMP")) {
            return 93;
        }
        if (fixed.contains("TIME")) {
            return 92;
        }
        if (fixed.contains("REAL") || fixed.contains("NUMBER")) {
            return 7;
        }
        if (fixed.contains("FLOAT")) {
            return 6;
        }
        if (fixed.contains("DOUBLE")) {
            return 8;
        }
        if (fixed.equals("CHAR") && !fixed.contains("VAR")) {
            return 1;
        }
        if (fixed.contains("INT") && !fixed.contains("INTERVAL")) {
            return 4;
        }
        if (fixed.contains("DECIMAL")) {
            return 3;
        }
        if (fixed.contains("NUMERIC")) {
            return 2;
        }
        if (fixed.contains("CHAR") || fixed.contains("TEXT")) {
            return 12;
        }
        if (fixed.contains("BLOB")) {
            return 2004;
        }
        if (fixed.contains("CLOB")) {
            return 2005;
        }
        if (fixed.contains("REFERENCE")) {
            return 2006;
        }
        return 1111;
    }

    public static boolean isNumberType(int jdbcType) {
        boolean result;
        switch (jdbcType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean isStringType(int jdbcType) {
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(int jdbcType) {
        switch (jdbcType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static DasForeignKey.RuleAction getRuleAction(short value) {
        if (value == 0) {
            return DasForeignKey.RuleAction.CASCADE;
        }
        if (value == 1) {
            return DasForeignKey.RuleAction.RESTRICT;
        }
        if (value == 2) {
            return DasForeignKey.RuleAction.SET_NULL;
        }
        if (value == 3) {
            return DasForeignKey.RuleAction.NO_ACTION;
        }
        if (value == 4) {
            return DasForeignKey.RuleAction.SET_DEFAULT;
        }
        return null;
    }

    @Nullable
    public static DasForeignKey.Deferrability getDeferrability(short value) {
        if (value == 5) {
            return DasForeignKey.Deferrability.INITIALLY_DEFERRED;
        }
        if (value == 6) {
            return DasForeignKey.Deferrability.INITIALLY_IMMEDIATE;
        }
        if (value == 7) {
            return DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        return null;
    }

    @NotNull
    public static String getLongMessage(@NotNull Throwable e) {
        if (e == null) {
            JdbcUtil.$$$reportNull$$$0(22);
        }
        String string = JdbcUtil.getMessagePrefix(e) + JdbcUtil.getMessage(e);
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getMessage(@NotNull Throwable t) {
        String m;
        if (t == null) {
            JdbcUtil.$$$reportNull$$$0(24);
        }
        String string = StringUtil.isNotEmpty((String)(m = (String)ObjectUtils.chooseNotNull((Object)t.getLocalizedMessage(), (Object)t.getMessage()))) ? m.trim() : t.getClass().getName();
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String getMessagePrefix(@NotNull Throwable t) {
        if (t == null) {
            JdbcUtil.$$$reportNull$$$0(26);
        }
        if (!(t instanceof SQLException)) {
            if ("" == null) {
                JdbcUtil.$$$reportNull$$$0(27);
            }
            return "";
        }
        SQLException e = (SQLException)t;
        String state = e.getSQLState();
        int code = e.getErrorCode();
        if (StringUtil.isEmpty((String)state)) {
            String string = code != 0 ? "[" + code + "] " : "";
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        if (code != 0) {
            String string = "[" + state + "][" + code + "] ";
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = "[" + state + "] ";
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/JdbcUtil";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/JdbcUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resultSetToListSafe";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resultSetToStringSafe";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resultSetRowToStringSafe";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resultSetRowToMapSafe";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcTypeName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongMessage";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCatalogSafe";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resultSetToListSafe";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "columnNotAvailable";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resultSetToStringSafe";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resultSetRowToStringSafe";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resultSetRowToMapSafe";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcTypeName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLongMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMessagePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

