/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceDetector {
    public static final ExtensionPointName<DataSourceDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.dataSourceDetector");

    public void collectDataSources(@NotNull Project project, @NotNull Builder builder) {
        if (project == null) {
            DataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DataSourceDetector.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.collectDataSources(module, builder, false);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull Builder builder, boolean onTheFly) {
        if (module == null) {
            DataSourceDetector.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DataSourceDetector.$$$reportNull$$$0(3);
        }
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            DataSourceDetector.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/DataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelevantFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Property {
        NAME,
        URL,
        USERNAME,
        PASSWORD,
        DRIVER_CLASS,
        DRIVER_PATH;


        public void set(Builder b, String value) {
            switch (this) {
                case NAME: {
                    b.withName(value);
                    break;
                }
                case URL: {
                    b.withUrl(value);
                    break;
                }
                case USERNAME: {
                    b.withUser(value);
                    break;
                }
                case PASSWORD: {
                    b.withPassword(value);
                    break;
                }
                case DRIVER_CLASS: {
                    b.withDriverClass(value);
                    break;
                }
                case DRIVER_PATH: {
                    b.withDriverPath(value);
                }
            }
        }
    }

    public static abstract class Callback {
        public void onCreated(@NotNull DatabaseSystem dataSource) {
            if (dataSource == null) {
                Callback.$$$reportNull$$$0(0);
            }
        }

        public void onUpdated(@NotNull DatabaseSystem dataSource) {
            if (dataSource == null) {
                Callback.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/autoconfig/DataSourceDetector$Callback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Builder {
        public Builder commit(@NotNull String var1, @Nullable Object var2);

        public Builder reset();

        public Builder onCreate(@NotNull Callback var1);

        public Builder withName(@Nullable String var1);

        public Builder withDriverClass(@Nullable String var1);

        public Builder withUrl(@Nullable String var1);

        public Builder withUser(@Nullable String var1);

        public Builder withPassword(@Nullable String var1);

        public Builder withDriverPath(@Nullable String var1);

        public Builder with(@NotNull Property var1, @Nullable String var2);
    }
}

