/*
 * Decompiled with CFR 0.152.
 */
package clojure.contrib.jsr223;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class ClojureScriptEngineFactory
implements ScriptEngineFactory {
    private List<String> extensions;
    private List<String> names;
    private List<String> mimeTypes;

    public ClojureScriptEngineFactory() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("clj");
        this.extensions = Collections.unmodifiableList(list);
        list = new ArrayList(1);
        list.add("clojure");
        list.add("Clojure");
        this.names = Collections.unmodifiableList(list);
        list = new ArrayList(2);
        list.add("application/clojure");
        list.add("text/clojure");
        this.mimeTypes = Collections.unmodifiableList(list);
    }

    @Override
    public String getEngineName() {
        return "Clojure";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getEngineVersion() {
        Properties properties = new Properties();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("clojure/version.properties");
        try {
            try {
                if (stream != null) {
                    properties.load(stream);
                    String string = properties.getProperty("version", "unknown");
                    return string;
                }
                String string2 = "not found";
                return string2;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getLanguageName() {
        return "Clojure";
    }

    @Override
    public String getLanguageVersion() {
        return this.getEngineVersion();
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        if (obj == null) {
            throw new NullPointerException("obj is null");
        }
        if (m == null) {
            throw new NullPointerException("m is null");
        }
        StringBuilder b = new StringBuilder("(.");
        b.append(m).append(' ').append(obj);
        for (int i = 0; i < args.length; ++i) {
            b.append(' ').append(args[i]);
        }
        b.append(')');
        return b.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        if (toDisplay == null) {
            throw new NullPointerException("toDisplay is null");
        }
        return "(println \"" + toDisplay + "\")";
    }

    @Override
    public Object getParameter(String key) {
        return (String)this.getScriptEngine().get(key);
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            b.append(statements[i]).append('\n');
        }
        return b.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        try {
            Class<?> c = Class.forName("clojure.contrib.jsr223.ClojureScriptEngine");
            return (ScriptEngine)c.getConstructor(ScriptEngineFactory.class).newInstance(this);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

