/*
 * Decompiled with CFR 0.152.
 */
package clojure.contrib.jsr223;

import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.IMapEntry;
import clojure.lang.ISeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

class ClojureScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private static final Symbol USER_SYM = Symbol.create((String)"user");
    private static final Var IN_NS = RT.var((String)"clojure.core", (String)"in-ns");
    private static final String SOURCE_PATH_KEY = "clojure.source.path";
    private static final String COMPILE_PATH_KEY = "clojure.compile.path";
    private static final String WARN_REFLECTION_KEY = "clojure.compile.warn-on-reflection";
    private static final String CLASSPATH = System.getProperty("java.class.path");
    private final ScriptEngineFactory factory;

    public ClojureScriptEngine(ScriptEngineFactory sef) {
        if (sef == null) {
            throw new NullPointerException("factory is null");
        }
        this.factory = sef;
        Bindings engineScope = this.getBindings(100);
        engineScope.put("javax.script.engine", (Object)sef.getEngineName());
        engineScope.put("javax.script.engine_version", (Object)sef.getEngineVersion());
        engineScope.put("javax.script.name", (Object)sef.getEngineName());
        engineScope.put("javax.script.language", (Object)sef.getLanguageName());
        engineScope.put("javax.script.language_version", (Object)sef.getLanguageVersion());
        engineScope.put(SOURCE_PATH_KEY, (Object)null);
        engineScope.put(COMPILE_PATH_KEY, (Object)"classes");
        engineScope.put(WARN_REFLECTION_KEY, (Object)false);
    }

    private void applyBindings(Bindings bindings) {
        for (Map.Entry entry : bindings.entrySet()) {
            String key = (String)entry.getKey();
            if (key.indexOf(46) != -1) continue;
            String nsName = "user";
            if (key.indexOf(47) >= 0) {
                String[] names = key.split("/");
                nsName = names[0];
                key = names[1];
            }
            Object value = entry.getValue();
            Var.intern((Namespace)Namespace.findOrCreate((Symbol)Symbol.create((String)nsName.intern())), (Symbol)Symbol.create((String)key.intern()), value);
        }
    }

    private void collectBindings(Bindings bindings) {
        for (ISeq seq = Namespace.all(); seq != null; seq = seq.next()) {
            Namespace ns = (Namespace)seq.first();
            String nsName = ns.toString();
            if (nsName.startsWith("clojure")) continue;
            for (ISeq mseq = ns.getMappings().seq(); mseq != null; mseq = mseq.next()) {
                IMapEntry e = (IMapEntry)mseq.first();
                String k = e.getKey().toString();
                Object val = e.getValue();
                if (val.toString().startsWith("#'clojure") || !(val instanceof Var)) continue;
                val = ((Var)val).deref();
                bindings.put(nsName + "/" + k, val);
            }
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Object result = null;
        try {
            Bindings engineScope;
            Bindings globalScope = context.getBindings(200);
            if (globalScope != null) {
                this.applyBindings(globalScope);
            }
            if ((engineScope = context.getBindings(100)) != null) {
                this.applyBindings(engineScope);
            }
            Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{RT.CURRENT_NS, RT.CURRENT_NS.deref(), RT.IN, new LineNumberingPushbackReader(context.getReader()), RT.OUT, context.getWriter(), RT.ERR, context.getErrorWriter()}));
            IN_NS.invoke((Object)USER_SYM);
            result = Compiler.load((Reader)reader);
            if (globalScope != null) {
                this.collectBindings(engineScope);
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Var.popThreadBindings();
        }
        return result;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        if (clasz == null) {
            throw new NullPointerException("clasz is null");
        }
        String ns = "user";
        Var var = RT.var((String)ns, (String)(clasz.getSimpleName() + "Impl"));
        return (T)(var == null ? null : var.deref());
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new NullPointerException("thiz is null");
        }
        if (clasz == null) {
            throw new NullPointerException("clasz is null");
        }
        if (!(thiz instanceof String)) {
            throw new IllegalArgumentException("thiz is not a string");
        }
        String ns = (String)thiz;
        Var var = RT.var((String)ns, (String)(clasz.getSimpleName() + "Impl"));
        return (T)(var == null ? null : var.deref());
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Object result = null;
        String format = "Function %s not found in namespace %s";
        try {
            Bindings engineScope;
            Bindings globalScope = this.context.getBindings(200);
            if (globalScope != null) {
                this.applyBindings(globalScope);
            }
            if ((engineScope = this.context.getBindings(100)) != null) {
                this.applyBindings(engineScope);
            }
            Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{RT.CURRENT_NS, RT.CURRENT_NS.deref(), RT.IN, new LineNumberingPushbackReader(this.context.getReader()), RT.OUT, this.context.getWriter(), RT.ERR, this.context.getErrorWriter()}));
            if (name.indexOf(47) == -1) {
                String ns = "user";
                Var var = RT.var((String)ns, (String)name);
                if (var == null) {
                    String msg = String.format(format, name, ns);
                    throw new NoSuchMethodException(msg);
                }
                result = var.applyTo(RT.seq((Object)args));
            } else {
                String[] names = name.split("/");
                Var var = RT.var((String)names[0], (String)names[1]);
                if (var == null) {
                    String msg = String.format(format, names[1], names[0]);
                    throw new NoSuchMethodException(msg);
                }
                result = var.applyTo(RT.seq((Object)args));
            }
            if (globalScope != null) {
                this.collectBindings(engineScope);
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Var.popThreadBindings();
        }
        return result;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeFunction(name, args);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        String library = script.trim();
        if (library.length() == 0) {
            return null;
        }
        try {
            String src;
            StringBuffer classpath = new StringBuffer(CLASSPATH);
            String cmp = (String)this.get(COMPILE_PATH_KEY);
            if (cmp != null && cmp.length() > 0) {
                classpath.append(File.pathSeparatorChar).append(cmp);
            }
            if ((src = (String)this.get(SOURCE_PATH_KEY)) != null && src.length() > 0) {
                classpath.append(File.pathSeparatorChar).append(src);
            }
            String compile = String.format("java -D%s=%s -D%s=%b -cp %s clojure.lang.Compile %s", COMPILE_PATH_KEY, (String)this.get(COMPILE_PATH_KEY), WARN_REFLECTION_KEY, (Boolean)this.get(WARN_REFLECTION_KEY), classpath.toString(), library);
            Process process = Runtime.getRuntime().exec(compile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line).append('\n');
                line = reader.readLine();
            }
            reader.close();
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new ScriptException(buffer.toString());
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (InterruptedException e) {
            throw new ScriptException(e);
        }
        return null;
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        BufferedReader bf = new BufferedReader(script);
        try {
            String library = bf.readLine();
            while (library != null) {
                this.compile(library);
                library = bf.readLine();
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        finally {
            try {
                bf.close();
            }
            catch (IOException e) {
                throw new ScriptException(e);
            }
        }
        return null;
    }
}

